/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.lang.ref.WeakReference;
import java.sql.SQLException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.apache.tomcat.dbcp.dbcp2.Utils;
import org.apache.tomcat.dbcp.pool2.TrackedUse;

public class AbandonedTrace
implements TrackedUse,
AutoCloseable {
    private final List<WeakReference<AbandonedTrace>> traceList = new ArrayList<WeakReference<AbandonedTrace>>();
    private volatile Instant lastUsedInstant = Instant.EPOCH;

    static void add(AbandonedTrace abandonedTrace, AbandonedTrace abandonedTrace2) {
        if (abandonedTrace != null) {
            abandonedTrace.addTrace(abandonedTrace2);
        }
    }

    public AbandonedTrace() {
        this.init(null);
    }

    public AbandonedTrace(AbandonedTrace abandonedTrace) {
        this.init(abandonedTrace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTrace(AbandonedTrace abandonedTrace) {
        List<WeakReference<AbandonedTrace>> list = this.traceList;
        synchronized (list) {
            this.traceList.add(new WeakReference<AbandonedTrace>(abandonedTrace));
        }
        this.setLastUsed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearTrace() {
        List<WeakReference<AbandonedTrace>> list = this.traceList;
        synchronized (list) {
            this.traceList.clear();
        }
    }

    @Override
    public void close() throws SQLException {
    }

    protected void close(Consumer<Exception> consumer) {
        Utils.close(this, consumer);
    }

    @Override
    @Deprecated
    public long getLastUsed() {
        return this.lastUsedInstant.toEpochMilli();
    }

    @Override
    public Instant getLastUsedInstant() {
        return this.lastUsedInstant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<AbandonedTrace> getTrace() {
        List<WeakReference<AbandonedTrace>> list = this.traceList;
        synchronized (list) {
            int n = this.traceList.size();
            if (n == 0) {
                return Collections.emptyList();
            }
            ArrayList<AbandonedTrace> arrayList = new ArrayList<AbandonedTrace>(n);
            Iterator<WeakReference<AbandonedTrace>> iterator = this.traceList.iterator();
            while (iterator.hasNext()) {
                AbandonedTrace abandonedTrace = (AbandonedTrace)iterator.next().get();
                if (abandonedTrace == null) {
                    iterator.remove();
                    continue;
                }
                arrayList.add(abandonedTrace);
            }
            return arrayList;
        }
    }

    private void init(AbandonedTrace abandonedTrace) {
        AbandonedTrace.add(abandonedTrace, this);
    }

    protected void removeThisTrace(Object object) {
        if (object instanceof AbandonedTrace) {
            ((AbandonedTrace)AbandonedTrace.class.cast(object)).removeTrace(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTrace(AbandonedTrace abandonedTrace) {
        List<WeakReference<AbandonedTrace>> list = this.traceList;
        synchronized (list) {
            Iterator<WeakReference<AbandonedTrace>> iterator = this.traceList.iterator();
            while (iterator.hasNext()) {
                AbandonedTrace abandonedTrace2 = (AbandonedTrace)iterator.next().get();
                if (abandonedTrace != null && abandonedTrace.equals(abandonedTrace2)) {
                    iterator.remove();
                    break;
                }
                if (abandonedTrace2 != null) continue;
                iterator.remove();
            }
        }
    }

    protected void setLastUsed() {
        this.lastUsedInstant = Instant.now();
    }

    protected void setLastUsed(Instant instant) {
        this.lastUsedInstant = instant;
    }

    @Deprecated
    protected void setLastUsed(long l) {
        this.lastUsedInstant = Instant.ofEpochMilli(l);
    }
}

