/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import jakarta.servlet.jsp.tagext.FunctionInfo;
import jakarta.servlet.jsp.tagext.PageData;
import jakarta.servlet.jsp.tagext.TagAttributeInfo;
import jakarta.servlet.jsp.tagext.TagExtraInfo;
import jakarta.servlet.jsp.tagext.TagFileInfo;
import jakarta.servlet.jsp.tagext.TagInfo;
import jakarta.servlet.jsp.tagext.TagLibraryInfo;
import jakarta.servlet.jsp.tagext.TagLibraryValidator;
import jakarta.servlet.jsp.tagext.TagVariableInfo;
import jakarta.servlet.jsp.tagext.ValidationMessage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.compiler.ParserController;
import org.apache.jasper.compiler.TagConstants;
import org.apache.jasper.compiler.TagFileProcessor;
import org.apache.tomcat.Jar;
import org.apache.tomcat.util.buf.UriUtil;
import org.apache.tomcat.util.descriptor.tld.TagFileXml;
import org.apache.tomcat.util.descriptor.tld.TagXml;
import org.apache.tomcat.util.descriptor.tld.TldResourcePath;
import org.apache.tomcat.util.descriptor.tld.ValidatorXml;

class TagLibraryInfoImpl
extends TagLibraryInfo
implements TagConstants {
    private final JspCompilationContext ctxt;
    private final PageInfo pi;
    private final ErrorDispatcher err;
    private final ParserController parserController;
    private final TagLibraryValidator tagLibraryValidator;

    private static void print(String string, String string2, PrintWriter printWriter) {
        if (string2 != null) {
            printWriter.print(string + " = {\n\t");
            printWriter.print(string2);
            printWriter.print("\n}\n");
        }
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        TagLibraryInfoImpl.print("tlibversion", this.tlibversion, printWriter);
        TagLibraryInfoImpl.print("jspversion", this.jspversion, printWriter);
        TagLibraryInfoImpl.print("shortname", this.shortname, printWriter);
        TagLibraryInfoImpl.print("urn", this.urn, printWriter);
        TagLibraryInfoImpl.print("info", this.info, printWriter);
        TagLibraryInfoImpl.print("uri", this.uri, printWriter);
        TagLibraryInfoImpl.print("tagLibraryValidator", String.valueOf(this.tagLibraryValidator), printWriter);
        for (TagInfo tagInfo : this.tags) {
            printWriter.println(tagInfo.toString());
        }
        for (TagInfo tagInfo : this.tagFiles) {
            printWriter.println(tagInfo.toString());
        }
        for (TagInfo tagInfo : this.functions) {
            printWriter.println(tagInfo.toString());
        }
        return stringWriter.toString();
    }

    TagLibraryInfoImpl(JspCompilationContext jspCompilationContext, ParserController parserController, PageInfo pageInfo, String string, String string2, TldResourcePath tldResourcePath, ErrorDispatcher errorDispatcher) throws JasperException {
        super(string, string2);
        this.ctxt = jspCompilationContext;
        this.parserController = parserController;
        this.pi = pageInfo;
        this.err = errorDispatcher;
        if (tldResourcePath == null) {
            tldResourcePath = this.generateTldResourcePath(this.uri, jspCompilationContext);
        }
        try (Jar jar = tldResourcePath.openJar();){
            Object object3;
            HashSet<String> hashSet2;
            Object object2;
            String string3;
            PageInfo pageInfo2 = jspCompilationContext.createCompiler().getPageInfo();
            if (pageInfo2 != null) {
                string3 = tldResourcePath.getWebappPath();
                if (string3 != null) {
                    pageInfo2.addDependant(string3, jspCompilationContext.getLastModified(string3, null));
                }
                if (jar != null) {
                    if (string3 == null) {
                        long l;
                        object2 = jar.getJarFileURL();
                        hashSet2 = null;
                        try {
                            hashSet2 = ((URL)object2).openConnection();
                            l = ((URLConnection)((Object)hashSet2)).getLastModified();
                        }
                        catch (IOException iOException) {
                            throw new JasperException(iOException);
                        }
                        finally {
                            if (hashSet2 != null) {
                                try {
                                    ((URLConnection)((Object)hashSet2)).getInputStream().close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                        pageInfo2.addDependant(((URL)object2).toExternalForm(), l);
                    }
                    object2 = tldResourcePath.getEntryName();
                    try {
                        pageInfo2.addDependant(jar.getURL((String)object2), jar.getLastModified((String)object2));
                    }
                    catch (IOException iOException) {
                        throw new JasperException(iOException);
                    }
                }
            }
            if (tldResourcePath.getUrl() == null) {
                errorDispatcher.jspError("jsp.error.tld.missing", string, this.uri);
            }
            if ((string3 = jspCompilationContext.getOptions().getTldCache().getTaglibXml(tldResourcePath)) == null) {
                errorDispatcher.jspError("jsp.error.tld.missing", string, this.uri);
            }
            this.jspversion = object2 = string3.getJspVersion();
            this.tlibversion = string3.getTlibVersion();
            this.shortname = string3.getShortName();
            this.urn = string3.getUri();
            this.info = string3.getInfo();
            this.tagLibraryValidator = this.createValidator(string3.getValidator());
            ArrayList<TagInfo> arrayList = new ArrayList<TagInfo>();
            for (HashSet<String> hashSet2 : string3.getTags()) {
                arrayList.add(this.createTagInfo((TagXml)hashSet2));
            }
            ArrayList arrayList2 = new ArrayList();
            for (Object object3 : string3.getTagFiles()) {
                arrayList2.add(this.createTagFileInfo((TagFileXml)object3, jar));
            }
            hashSet2 = new HashSet<String>();
            object3 = string3.getFunctions();
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                FunctionInfo functionInfo = (FunctionInfo)iterator.next();
                String string4 = functionInfo.getName();
                if (hashSet2.add(string4)) continue;
                errorDispatcher.jspError("jsp.error.tld.fn.duplicate.name", string4, this.uri);
            }
            if (this.tlibversion == null) {
                errorDispatcher.jspError("jsp.error.tld.mandatory.element.missing", "tlib-version", this.uri);
            }
            if (this.jspversion == null) {
                errorDispatcher.jspError("jsp.error.tld.mandatory.element.missing", "jsp-version", this.uri);
            }
            this.tags = arrayList.toArray(new TagInfo[0]);
            this.tagFiles = arrayList2.toArray(new TagFileInfo[0]);
            this.functions = object3.toArray(new FunctionInfo[0]);
        }
        catch (IOException iOException) {
            throw new JasperException(iOException);
        }
    }

    public TagLibraryInfo[] getTagLibraryInfos() {
        Collection<TagLibraryInfo> collection = this.pi.getTaglibs();
        return collection.toArray(new TagLibraryInfo[0]);
    }

    private TldResourcePath generateTldResourcePath(String string, JspCompilationContext jspCompilationContext) throws JasperException {
        if (string.indexOf(58) != -1) {
            this.err.jspError("jsp.error.taglibDirective.absUriCannotBeResolved", string);
        } else if (string.charAt(0) != '/') {
            string = jspCompilationContext.resolveRelativeUri(string);
            try {
                string = new URI(string).normalize().toString();
                if (string.startsWith("../")) {
                    this.err.jspError("jsp.error.taglibDirective.uriInvalid", string);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                this.err.jspError("jsp.error.taglibDirective.uriInvalid", string);
            }
        }
        URL uRL = null;
        try {
            uRL = jspCompilationContext.getResource(string);
            if (uRL == null) {
                throw new FileNotFoundException();
            }
            if (uRL.getProtocol().equals("war") && string.endsWith(".jar")) {
                uRL = UriUtil.warToJar((URL)uRL);
            }
        }
        catch (Exception exception) {
            this.err.jspError("jsp.error.tld.unable_to_get_jar", string, exception.toString());
        }
        if (string.endsWith(".jar")) {
            if (uRL == null) {
                this.err.jspError("jsp.error.tld.missing_jar", string);
            }
            return new TldResourcePath(uRL, string, "META-INF/taglib.tld");
        }
        if (string.startsWith("/WEB-INF/lib/") || string.startsWith("/WEB-INF/classes/") || string.startsWith("/WEB-INF/tags/") && string.endsWith(".tld") && !string.endsWith("implicit.tld")) {
            this.err.jspError("jsp.error.tld.invalid_tld_file", string);
        }
        return new TldResourcePath(uRL, string);
    }

    private TagInfo createTagInfo(TagXml tagXml) throws JasperException {
        Object object;
        String string = tagXml.getTeiClass();
        TagExtraInfo tagExtraInfo = null;
        if (string != null && !string.isEmpty()) {
            try {
                object = this.ctxt.getClassLoader().loadClass(string);
                tagExtraInfo = (TagExtraInfo)((Class)object).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                this.err.jspError(exception, "jsp.error.teiclass.instantiation", string);
            }
        }
        object = tagXml.getAttributes();
        List list = tagXml.getVariables();
        return new TagInfo(tagXml.getName(), tagXml.getTagClass(), tagXml.getBodyContent(), tagXml.getInfo(), (TagLibraryInfo)this, tagExtraInfo, object.toArray(new TagAttributeInfo[0]), tagXml.getDisplayName(), tagXml.getSmallIcon(), tagXml.getLargeIcon(), list.toArray(new TagVariableInfo[0]), tagXml.hasDynamicAttributes());
    }

    private TagFileInfo createTagFileInfo(TagFileXml tagFileXml, Jar jar) throws JasperException {
        String string = tagFileXml.getName();
        Object object = tagFileXml.getPath();
        if (object == null) {
            this.err.jspError("jsp.error.tagfile.missingPath", new String[0]);
        } else if (!((String)object).startsWith("/META-INF/tags") && !((String)object).startsWith("/WEB-INF/tags")) {
            this.err.jspError("jsp.error.tagfile.illegalPath", new String[]{object});
        }
        if (jar == null && ((String)object).startsWith("/META-INF/tags")) {
            object = "/WEB-INF/classes" + (String)object;
        }
        TagInfo tagInfo = TagFileProcessor.parseTagFileDirectives(this.parserController, string, (String)object, jar, this);
        return new TagFileInfo(string, (String)object, tagInfo);
    }

    private TagLibraryValidator createValidator(ValidatorXml validatorXml) throws JasperException {
        if (validatorXml == null) {
            return null;
        }
        String string = validatorXml.getValidatorClass();
        if (string == null || string.isEmpty()) {
            return null;
        }
        HashMap hashMap = new HashMap(validatorXml.getInitParams());
        try {
            Class<?> clazz = this.ctxt.getClassLoader().loadClass(string);
            TagLibraryValidator tagLibraryValidator = (TagLibraryValidator)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            tagLibraryValidator.setInitParameters(hashMap);
            return tagLibraryValidator;
        }
        catch (Exception exception) {
            this.err.jspError(exception, "jsp.error.tlvclass.instantiation", string);
            return null;
        }
    }

    public TagLibraryValidator getTagLibraryValidator() {
        return this.tagLibraryValidator;
    }

    public ValidationMessage[] validate(PageData pageData) {
        TagLibraryValidator tagLibraryValidator = this.getTagLibraryValidator();
        if (tagLibraryValidator == null) {
            return null;
        }
        Object object = this.getURI();
        if (((String)object).startsWith("/")) {
            object = "urn:jsptld:" + (String)object;
        }
        return tagLibraryValidator.validate(this.getPrefixString(), (String)object, pageData);
    }
}

