/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ContextAccessController {
    private static final Map<Object, Object> readOnlyContexts = new ConcurrentHashMap<Object, Object>();
    private static final Map<Object, Object> securityTokens = new ConcurrentHashMap<Object, Object>();

    public static void setSecurityToken(Object object, Object object2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission(ContextAccessController.class.getName() + ".setSecurityToken"));
        }
        if (!securityTokens.containsKey(object) && object2 != null) {
            securityTokens.put(object, object2);
        }
    }

    public static void unsetSecurityToken(Object object, Object object2) {
        if (ContextAccessController.checkSecurityToken(object, object2)) {
            securityTokens.remove(object);
        }
    }

    public static boolean checkSecurityToken(Object object, Object object2) {
        Object object3 = securityTokens.get(object);
        return object3 == null || object3.equals(object2);
    }

    public static void setWritable(Object object, Object object2) {
        if (ContextAccessController.checkSecurityToken(object, object2)) {
            readOnlyContexts.remove(object);
        }
    }

    public static void setReadOnly(Object object) {
        readOnlyContexts.put(object, object);
    }

    public static boolean isWritable(Object object) {
        return !readOnlyContexts.containsKey(object);
    }
}

