/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.xbill.DNS;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.shaded.org.xbill.DNS.ClientSubnetOption;
import org.apache.hadoop.shaded.org.xbill.DNS.CookieOption;
import org.apache.hadoop.shaded.org.xbill.DNS.DNSInput;
import org.apache.hadoop.shaded.org.xbill.DNS.DNSOutput;
import org.apache.hadoop.shaded.org.xbill.DNS.DnssecAlgorithmOption;
import org.apache.hadoop.shaded.org.xbill.DNS.ExtendedErrorCodeOption;
import org.apache.hadoop.shaded.org.xbill.DNS.GenericEDNSOption;
import org.apache.hadoop.shaded.org.xbill.DNS.Mnemonic;
import org.apache.hadoop.shaded.org.xbill.DNS.NSIDOption;
import org.apache.hadoop.shaded.org.xbill.DNS.Record;
import org.apache.hadoop.shaded.org.xbill.DNS.TcpKeepaliveOption;
import org.apache.hadoop.shaded.org.xbill.DNS.WireParseException;

public abstract class EDNSOption {
    private final int code;

    public EDNSOption(int code) {
        this.code = Record.checkU16("code", code);
    }

    public String toString() {
        return "{" + Code.string(this.code) + ": " + this.optionToString() + "}";
    }

    public int getCode() {
        return this.code;
    }

    byte[] getData() {
        DNSOutput out = new DNSOutput();
        this.optionToWire(out);
        return out.toByteArray();
    }

    abstract void optionFromWire(DNSInput var1) throws IOException;

    static EDNSOption fromWire(DNSInput in) throws IOException {
        EDNSOption option;
        int code = in.readU16();
        int length = in.readU16();
        if (in.remaining() < length) {
            throw new WireParseException("truncated option");
        }
        int save = in.saveActive();
        in.setActive(length);
        switch (code) {
            case 3: {
                option = new NSIDOption();
                break;
            }
            case 8: {
                option = new ClientSubnetOption();
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                option = new DnssecAlgorithmOption(code, new int[0]);
                break;
            }
            case 10: {
                option = new CookieOption();
                break;
            }
            case 11: {
                option = new TcpKeepaliveOption();
                break;
            }
            case 15: {
                option = new ExtendedErrorCodeOption();
                break;
            }
            default: {
                option = new GenericEDNSOption(code);
            }
        }
        ((EDNSOption)option).optionFromWire(in);
        in.restoreActive(save);
        return option;
    }

    public static EDNSOption fromWire(byte[] b) throws IOException {
        return EDNSOption.fromWire(new DNSInput(b));
    }

    abstract void optionToWire(DNSOutput var1);

    void toWire(DNSOutput out) {
        out.writeU16(this.code);
        int lengthPosition = out.current();
        out.writeU16(0);
        this.optionToWire(out);
        int length = out.current() - lengthPosition - 2;
        out.writeU16At(length, lengthPosition);
    }

    public byte[] toWire() {
        DNSOutput out = new DNSOutput();
        this.toWire(out);
        return out.toByteArray();
    }

    public boolean equals(Object arg) {
        if (!(arg instanceof EDNSOption)) {
            return false;
        }
        EDNSOption opt = (EDNSOption)arg;
        if (this.code != opt.code) {
            return false;
        }
        return Arrays.equals(this.getData(), opt.getData());
    }

    public int hashCode() {
        byte[] array = this.getData();
        int hashval = 0;
        for (byte b : array) {
            hashval += (hashval << 3) + (b & 0xFF);
        }
        return hashval;
    }

    abstract String optionToString();

    public static class Code {
        public static final int LLQ = 1;
        public static final int UL = 2;
        public static final int NSID = 3;
        public static final int DAU = 5;
        public static final int DHU = 6;
        public static final int N3U = 7;
        public static final int CLIENT_SUBNET = 8;
        public static final int EDNS_EXPIRE = 9;
        public static final int COOKIE = 10;
        public static final int TCP_KEEPALIVE = 11;
        public static final int PADDING = 12;
        public static final int CHAIN = 13;
        public static final int EDNS_KEY_TAG = 14;
        public static final int EDNS_EXTENDED_ERROR = 15;
        public static final int EDNS_CLIENT_TAG = 16;
        public static final int EDNS_SERVER_TAG = 17;
        public static final int REPORT_CHANNEL = 18;
        private static final Mnemonic codes = new Mnemonic("EDNS Option Codes", 1);

        private Code() {
        }

        public static String string(int code) {
            return codes.getText(code);
        }

        public static int value(String s2) {
            return codes.getValue(s2);
        }

        static {
            codes.setMaximum(65535);
            codes.setPrefix("CODE");
            codes.setNumericAllowed(true);
            codes.add(1, "LLQ");
            codes.add(2, "UL");
            codes.add(3, "NSID");
            codes.add(5, "DAU");
            codes.add(6, "DHU");
            codes.add(7, "N3U");
            codes.add(8, "edns-client-subnet");
            codes.add(9, "EDNS_EXPIRE");
            codes.add(10, "COOKIE");
            codes.add(11, "edns-tcp-keepalive");
            codes.add(12, "Padding");
            codes.add(13, "CHAIN");
            codes.add(14, "edns-key-tag");
            codes.add(15, "Extended_DNS_Error");
            codes.add(16, "EDNS-Client-Tag");
            codes.add(17, "EDNS-Server-Tag");
            codes.add(18, "Report-Channel");
        }
    }
}

