/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.ltr.feature;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.ltr.DocInfo;
import org.apache.solr.ltr.feature.FeatureException;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.macro.MacroExpander;
import org.apache.solr.util.SolrPluginUtils;

public abstract class Feature
extends Query
implements Accountable {
    private static final long BASE_RAM_BYTES = RamUsageEstimator.shallowSizeOfInstance(Feature.class);
    protected final String name;
    private int index = -1;
    private float defaultValue = 0.0f;
    private Object defaultValueObject = null;
    private final Map<String, Object> params;

    public static Feature getInstance(SolrResourceLoader solrResourceLoader, String className, String name, Map<String, Object> params) {
        Feature f = (Feature)((Object)solrResourceLoader.newInstance(className, Feature.class, new String[0], new Class[]{String.class, Map.class}, new Object[]{name, params}));
        if (params != null) {
            SolrPluginUtils.invokeSetters((Object)((Object)f), params.entrySet());
        }
        f.validate();
        return f;
    }

    public Feature(String name, Map<String, Object> params) {
        this.name = name;
        this.params = params;
    }

    protected abstract void validate() throws FeatureException;

    public String toString(String field) {
        StringBuilder sb = new StringBuilder(64);
        sb.append(((Object)((Object)this)).getClass().getSimpleName());
        sb.append(" [name=").append(this.name);
        LinkedHashMap<String, Object> params = this.paramsToMap();
        if (params != null) {
            sb.append(", params=").append(params);
        }
        sb.append(']');
        return sb.toString();
    }

    public abstract FeatureWeight createWeight(IndexSearcher var1, boolean var2, SolrQueryRequest var3, Query var4, Map<String, String[]> var5) throws IOException;

    public float getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object obj) {
        this.defaultValueObject = obj;
        if (obj instanceof String) {
            this.defaultValue = Float.parseFloat((String)obj);
        } else if (obj instanceof Double) {
            this.defaultValue = ((Double)obj).floatValue();
        } else if (obj instanceof Float) {
            this.defaultValue = ((Float)obj).floatValue();
        } else if (obj instanceof Integer) {
            this.defaultValue = ((Integer)obj).floatValue();
        } else if (obj instanceof Long) {
            this.defaultValue = ((Long)obj).floatValue();
        } else {
            throw new FeatureException("Invalid type for 'defaultValue' in params for " + String.valueOf((Object)this));
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = this.classHash();
        result = 31 * result + this.index;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.params == null ? 0 : this.params.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        return this.sameClassAs(o) && this.equalsTo((Feature)((Object)((Object)((Object)this)).getClass().cast(o)));
    }

    public long ramBytesUsed() {
        return BASE_RAM_BYTES + RamUsageEstimator.sizeOfObject((Object)this.name) + RamUsageEstimator.sizeOfObject(this.params);
    }

    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf((Query)this);
    }

    private boolean equalsTo(Feature other) {
        if (this.index != other.index) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.params == null ? other.params != null : !this.params.equals(other.params));
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public abstract LinkedHashMap<String, Object> paramsToMap();

    protected LinkedHashMap<String, Object> defaultParamsToMap() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        if (this.defaultValueObject != null) {
            params.put("defaultValue", this.defaultValueObject);
        }
        return params;
    }

    public abstract class FeatureWeight
    extends Weight {
        protected final IndexSearcher searcher;
        protected final SolrQueryRequest request;
        protected final Map<String, String[]> efi;
        protected final MacroExpander macroExpander;
        protected final Query originalQuery;

        public FeatureWeight(Query q, IndexSearcher searcher, SolrQueryRequest request, Query originalQuery, Map<String, String[]> efi) {
            super(q);
            this.searcher = searcher;
            this.request = request;
            this.originalQuery = originalQuery;
            this.efi = efi;
            this.macroExpander = new MacroExpander(efi, true);
        }

        public String getName() {
            return Feature.this.getName();
        }

        public int getIndex() {
            return Feature.this.getIndex();
        }

        public float getDefaultValue() {
            return Feature.this.getDefaultValue();
        }

        public abstract FeatureScorer scorer(LeafReaderContext var1) throws IOException;

        public boolean isCacheable(LeafReaderContext ctx) {
            return false;
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            FeatureScorer r = this.scorer(context);
            float score = this.getDefaultValue();
            if (r != null) {
                r.iterator().advance(doc);
                if (r.docID() == doc) {
                    score = r.score();
                }
                return Explanation.match((Number)Float.valueOf(score), (String)this.toString(), (Explanation[])new Explanation[0]);
            }
            return Explanation.match((Number)Float.valueOf(score), (String)"The feature has no value", (Explanation[])new Explanation[0]);
        }

        public String toString() {
            return Feature.this.toString();
        }

        public class ValueFeatureScorer
        extends FeatureScorer {
            float constScore;

            public ValueFeatureScorer(FeatureWeight weight, float constScore, DocIdSetIterator itr) {
                super(weight, itr);
                this.constScore = constScore;
            }

            @Override
            public float score() {
                return this.constScore;
            }

            public float getMaxScore(int upTo) throws IOException {
                return this.constScore;
            }
        }

        public abstract class FilterFeatureScorer
        extends FeatureScorer {
            protected final Scorer in;

            public FilterFeatureScorer(FeatureWeight weight, Scorer scorer) {
                super(weight, null);
                this.in = scorer;
            }

            @Override
            public int docID() {
                return this.in.docID();
            }

            @Override
            public DocIdSetIterator iterator() {
                return this.in.iterator();
            }

            public int advanceShallow(int target) throws IOException {
                return this.in.advanceShallow(target);
            }

            public float getMaxScore(int upTo) throws IOException {
                return this.in.getMaxScore(upTo);
            }
        }

        public abstract class FeatureScorer
        extends Scorer {
            protected final String name;
            private DocInfo docInfo;
            protected final DocIdSetIterator itr;

            public FeatureScorer(FeatureWeight weight, DocIdSetIterator itr) {
                super((Weight)weight);
                this.itr = itr;
                this.name = weight.getName();
                this.docInfo = null;
            }

            public abstract float score() throws IOException;

            public void setDocInfo(DocInfo docInfo) {
                this.docInfo = docInfo;
            }

            public DocInfo getDocInfo() {
                return this.docInfo;
            }

            public int docID() {
                return this.itr.docID();
            }

            public DocIdSetIterator iterator() {
                return this.itr;
            }
        }
    }
}

