/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.lz4;

import java.nio.ByteBuffer;
import net.jpountz.lz4.LZ4ByteBufferUtils;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4FastDecompressor;
import net.jpountz.lz4.LZ4SafeUtils;
import net.jpountz.util.ByteBufferUtils;
import net.jpountz.util.SafeUtils;

final class LZ4JavaSafeFastDecompressor
extends LZ4FastDecompressor {
    public static final LZ4FastDecompressor INSTANCE = new LZ4JavaSafeFastDecompressor();

    LZ4JavaSafeFastDecompressor() {
    }

    @Override
    public int decompress(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        int n5;
        int n6;
        SafeUtils.checkRange(byArray, n2);
        SafeUtils.checkRange(byArray2, n3, n4);
        if (n4 == 0) {
            if (SafeUtils.readByte(byArray, n2) != 0) {
                throw new LZ4Exception("Malformed input at " + n2);
            }
            return 1;
        }
        int n7 = n3 + n4;
        int n8 = n2;
        int n9 = n3;
        while (true) {
            int n10;
            int n11 = SafeUtils.readByte(byArray, n8) & 0xFF;
            ++n8;
            n6 = n11 >>> 4;
            if (n6 == 15) {
                n5 = -1;
                while (true) {
                    byte by2 = SafeUtils.readByte(byArray, n8++);
                    n5 = by2;
                    if (by2 != -1) break;
                    n6 += 255;
                }
                n6 += n5 & 0xFF;
            }
            if ((n5 = n9 + n6) > n7 - 8) {
                if (n5 != n7) {
                    throw new LZ4Exception("Malformed input at " + n8);
                }
                break;
            }
            LZ4SafeUtils.wildArraycopy(byArray, n8, byArray2, n9, n6);
            n9 = n5;
            int n12 = SafeUtils.readShortLE(byArray, n8 += n6);
            n8 += 2;
            int n13 = n9 - n12;
            if (n13 < n3) {
                throw new LZ4Exception("Malformed input at " + n8);
            }
            int n14 = n11 & 0xF;
            if (n14 == 15) {
                n10 = -1;
                while (true) {
                    byte by3 = SafeUtils.readByte(byArray, n8++);
                    n10 = by3;
                    if (by3 != -1) break;
                    n14 += 255;
                }
                n14 += n10 & 0xFF;
            }
            if ((n10 = n9 + (n14 += 4)) > n7 - 8) {
                if (n10 > n7) {
                    throw new LZ4Exception("Malformed input at " + n8);
                }
                LZ4SafeUtils.safeIncrementalCopy(byArray2, n13, n9, n14);
            } else {
                LZ4SafeUtils.wildIncrementalCopy(byArray2, n13, n9, n10);
            }
            n9 = n10;
        }
        LZ4SafeUtils.safeArraycopy(byArray, n8, byArray2, n9, n6);
        n9 = n5;
        return (n8 += n6) - n2;
    }

    @Override
    public int decompress(ByteBuffer byteBuffer, int n2, ByteBuffer byteBuffer2, int n3, int n4) {
        int n5;
        int n6;
        if (byteBuffer.hasArray() && byteBuffer2.hasArray()) {
            return this.decompress(byteBuffer.array(), n2 + byteBuffer.arrayOffset(), byteBuffer2.array(), n3 + byteBuffer2.arrayOffset(), n4);
        }
        byteBuffer = ByteBufferUtils.inNativeByteOrder(byteBuffer);
        byteBuffer2 = ByteBufferUtils.inNativeByteOrder(byteBuffer2);
        ByteBufferUtils.checkRange(byteBuffer, n2);
        ByteBufferUtils.checkRange(byteBuffer2, n3, n4);
        if (n4 == 0) {
            if (ByteBufferUtils.readByte(byteBuffer, n2) != 0) {
                throw new LZ4Exception("Malformed input at " + n2);
            }
            return 1;
        }
        int n7 = n3 + n4;
        int n8 = n2;
        int n9 = n3;
        while (true) {
            int n10;
            int n11 = ByteBufferUtils.readByte(byteBuffer, n8) & 0xFF;
            ++n8;
            n6 = n11 >>> 4;
            if (n6 == 15) {
                n5 = -1;
                while (true) {
                    byte by2 = ByteBufferUtils.readByte(byteBuffer, n8++);
                    n5 = by2;
                    if (by2 != -1) break;
                    n6 += 255;
                }
                n6 += n5 & 0xFF;
            }
            if ((n5 = n9 + n6) > n7 - 8) {
                if (n5 != n7) {
                    throw new LZ4Exception("Malformed input at " + n8);
                }
                break;
            }
            LZ4ByteBufferUtils.wildArraycopy(byteBuffer, n8, byteBuffer2, n9, n6);
            n9 = n5;
            int n12 = ByteBufferUtils.readShortLE(byteBuffer, n8 += n6);
            n8 += 2;
            int n13 = n9 - n12;
            if (n13 < n3) {
                throw new LZ4Exception("Malformed input at " + n8);
            }
            int n14 = n11 & 0xF;
            if (n14 == 15) {
                n10 = -1;
                while (true) {
                    byte by3 = ByteBufferUtils.readByte(byteBuffer, n8++);
                    n10 = by3;
                    if (by3 != -1) break;
                    n14 += 255;
                }
                n14 += n10 & 0xFF;
            }
            if ((n10 = n9 + (n14 += 4)) > n7 - 8) {
                if (n10 > n7) {
                    throw new LZ4Exception("Malformed input at " + n8);
                }
                LZ4ByteBufferUtils.safeIncrementalCopy(byteBuffer2, n13, n9, n14);
            } else {
                LZ4ByteBufferUtils.wildIncrementalCopy(byteBuffer2, n13, n9, n10);
            }
            n9 = n10;
        }
        LZ4ByteBufferUtils.safeArraycopy(byteBuffer, n8, byteBuffer2, n9, n6);
        n9 = n5;
        return (n8 += n6) - n2;
    }
}

