/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.net.ns.NetException;
import oracle.net.ns.Packet;
import oracle.net.ns.SQLnetDef;

@DefaultLogger(value="oracle.net.ns")
@Supports(value={Feature.NET})
public class RefusePacket
extends Packet
implements SQLnetDef {
    protected int userReason;
    protected int systemReason;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;

    public RefusePacket(Packet pkt) throws IOException, NetException {
        super(pkt);
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, RefusePacket.class, $$$methodRef$$$0, null, pkt);
            }
            this.userReason = this.buffer[8];
            this.systemReason = this.buffer[9];
            this.dataOff = 12;
            this.dataLen = this.buffer[10] & 0xFF;
            this.dataLen <<= 8;
            this.dataLen |= this.buffer[11] & 0xFF;
            if (bl) {
                this.debug($$$loggerRef$$$0, Level.FINEST, $$$methodRef$$$0, "Displaying Refuse packet information:\nreason=" + this.userReason + ", systemReason=" + this.systemReason + ", dataLen=" + this.dataLen + ", sessionTraceId=" + this.sAtts.traceId);
            }
            this.extractData();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, RefusePacket.class, $$$methodRef$$$0, null);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, RefusePacket.class, $$$methodRef$$$0, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, RefusePacket.class, $$$methodRef$$$0, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    static {
        try {
            $$$methodRef$$$0 = RefusePacket.class.getDeclaredConstructor(Packet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
    }
}

