/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RepeatingNode;
import com.oracle.truffle.js.nodes.JSNodeUtil;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanUnaryNode;
import com.oracle.truffle.js.nodes.control.ResumableNode;
import com.oracle.truffle.js.nodes.control.StatementNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTaggedExecutionNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.runtime.JSInterruptedExecutionException;
import java.util.Set;

abstract class AbstractRepeatingNode
extends JavaScriptNode
implements RepeatingNode,
ResumableNode {
    @Node.Child
    protected JavaScriptNode conditionNode;
    @Node.Child
    protected JavaScriptNode bodyNode;

    AbstractRepeatingNode(JavaScriptNode condition, JavaScriptNode body) {
        this.conditionNode = condition == null ? null : JSToBooleanUnaryNode.create(condition);
        this.bodyNode = body;
    }

    protected final boolean executeCondition(VirtualFrame frame) {
        return StatementNode.executeConditionAsBoolean(frame, this.conditionNode);
    }

    protected final void executeBody(VirtualFrame frame) {
        this.bodyNode.executeVoid(frame);
        if (CompilerDirectives.inInterpreter()) {
            this.checkThreadInterrupted();
        }
    }

    private void checkThreadInterrupted() {
        CompilerAsserts.neverPartOfCompilation((String)"do not check thread interruption from compiled code");
        if (Thread.interrupted()) {
            throw new JSInterruptedExecutionException("Thread was interrupted.", this);
        }
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.executeRepeating(frame);
    }

    protected boolean materializationNeeded() {
        return !JSNodeUtil.isTaggedNode(this.bodyNode);
    }

    public abstract AbstractRepeatingNode materializeInstrumentableNodes(Set<Class<? extends Tag>> var1);

    protected final JavaScriptNode materializeBody(Set<Class<? extends Tag>> materializedTags) {
        if (JSNodeUtil.isTaggedNode(this.bodyNode)) {
            return this.bodyNode;
        }
        JavaScriptNode newBody = JSTaggedExecutionNode.createFor(this.bodyNode, JSTags.ControlFlowBlockTag.class, materializedTags);
        if (newBody == this.bodyNode) {
            newBody = AbstractRepeatingNode.cloneUninitialized(this.bodyNode, materializedTags);
        }
        return newBody;
    }

    protected final JavaScriptNode materializeCondition(Set<Class<? extends Tag>> materializedTags) {
        if (this.conditionNode == null || JSNodeUtil.isTaggedNode(this.conditionNode)) {
            return this.conditionNode;
        }
        JavaScriptNode newCondition = JSTaggedExecutionNode.createForInput(this.conditionNode, JSTags.ControlFlowBranchTag.class, JSTags.createNodeObjectDescriptor("type", JSTags.ControlFlowBranchTag.Type.Condition.name()), materializedTags);
        if (newCondition == this.conditionNode) {
            newCondition = AbstractRepeatingNode.cloneUninitialized(this.conditionNode, materializedTags);
        }
        return newCondition;
    }
}

