/*
 * Decompiled with CFR 0.152.
 */
package com.informix.util;

import java.io.IOException;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class TraceFlag {
    public static boolean compiletrace = false;
    public static boolean loggerTrace = false;

    private TraceFlag() {
    }

    public static boolean isTraceEnabled() {
        return compiletrace;
    }

    public static void enableTrace(boolean enable) {
        compiletrace = enable;
    }

    public static boolean configureTracing(Properties connInfo) {
        boolean traceOptionOVerride = false;
        if (connInfo.getProperty("PROTOCOLTRACEFILE") != null || connInfo.getProperty("TRACEFILE") != null) {
            compiletrace = true;
            if (!loggerTrace) {
                traceOptionOVerride = true;
            }
            loggerTrace = true;
            Logger logger = Logger.getLogger("com.informix.jdbc");
            for (Handler h : logger.getHandlers()) {
                logger.removeHandler(h);
            }
            try {
                FileHandler handler = new FileHandler(connInfo.getProperty("PROTOCOLTRACEFILE") != null ? connInfo.getProperty("PROTOCOLTRACEFILE") : connInfo.getProperty("TRACEFILE"));
                handler.setLevel(TraceFlag.mapLevel(Integer.parseInt(connInfo.getProperty("TRACE", connInfo.getProperty("PROTOCOLTRACE", "1")))));
                logger.addHandler(handler);
            }
            catch (IOException | SecurityException e) {
                throw new RuntimeException(e);
            }
        } else if (LogManager.getLogManager().getProperty("com.informix.jdbc.level") != null) {
            compiletrace = true;
        }
        return traceOptionOVerride;
    }

    public static Level mapLevel(int oldLevel) {
        switch (oldLevel) {
            case 0: {
                return Level.OFF;
            }
            case 1: {
                return Level.FINE;
            }
            case 2: {
                return Level.FINER;
            }
        }
        return Level.FINEST;
    }
}

