/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.jdk;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.ser.jdk.BooleanSerializer;
import tools.jackson.databind.ser.jdk.NumberSerializer;
import tools.jackson.databind.ser.jdk.NumberSerializers;
import tools.jackson.databind.ser.jdk.StringSerializer;
import tools.jackson.databind.ser.std.ToStringSerializer;

public class JDKCoreSerializers {
    protected static final HashMap<String, ValueSerializer<?>> _concrete;

    public static final ValueSerializer<?> find(Class<?> raw) {
        return _concrete.get(raw.getName());
    }

    static {
        HashMap concrete = new HashMap();
        concrete.put(String.class.getName(), StringSerializer.instance);
        ToStringSerializer sls = ToStringSerializer.instance;
        concrete.put(StringBuffer.class.getName(), sls);
        concrete.put(StringBuilder.class.getName(), sls);
        concrete.put(Character.class.getName(), sls);
        concrete.put(Character.TYPE.getName(), sls);
        NumberSerializers.addAll(concrete);
        concrete.put(Boolean.TYPE.getName(), new BooleanSerializer(true));
        concrete.put(Boolean.class.getName(), new BooleanSerializer(false));
        concrete.put(BigInteger.class.getName(), new NumberSerializer((Class<? extends Number>)BigInteger.class));
        concrete.put(BigDecimal.class.getName(), new NumberSerializer((Class<? extends Number>)BigDecimal.class));
        _concrete = concrete;
    }
}

