/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jaybird.xca;

import org.firebirdsql.jaybird.xca.FBManagedConnection;
import org.firebirdsql.jdbc.FirebirdConnection;

public final class XcaConnectionEvent {
    private final FBManagedConnection source;
    private final EventType eventType;
    private final Exception exception;
    private FirebirdConnection connectionHandle;

    public XcaConnectionEvent(FBManagedConnection source, EventType eventType) {
        this(source, eventType, null);
    }

    public XcaConnectionEvent(FBManagedConnection source, EventType eventType, Exception exception) {
        assert (exception != null || eventType != EventType.CONNECTION_ERROR_OCCURRED) : "Exception required for CONNECTION_ERROR_OCCURRED";
        this.source = source;
        this.eventType = eventType;
        this.exception = exception;
    }

    public FBManagedConnection getSource() {
        return this.source;
    }

    public FirebirdConnection getConnectionHandle() {
        return this.connectionHandle;
    }

    public void setConnectionHandle(FirebirdConnection connectionHandle) {
        this.connectionHandle = connectionHandle;
    }

    public Exception getException() {
        return this.exception;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public static enum EventType {
        CONNECTION_CLOSED,
        CONNECTION_ERROR_OCCURRED;

    }
}

