-- SchemaCrawler
-- http://www.schemacrawler.com
-- Copyright (c) 2000-2026, Sualeh Fatehi <sualeh@hotmail.com>.
-- All rights reserved.
-- SPDX-License-Identifier: EPL-2.0

SELECT
	R.ROUTINE_CATALOG AS FUNCTION_CAT,
	R.ROUTINE_SCHEMA AS FUNCTION_SCHEM,
	R.ROUTINE_NAME AS FUNCTION_NAME,
	NULL AS SPECIFIC_NAME,
	CASE DATALENGTH(P.PARAMETER_NAME)
		WHEN 0 THEN '@RETURN_VALUE'
		ELSE P.PARAMETER_NAME
	END
		AS COLUMN_NAME,
	CASE
		WHEN P.PARAMETER_MODE = 'IN' THEN 1
		WHEN P.PARAMETER_MODE = 'OUT' THEN 4
		WHEN P.PARAMETER_MODE = 'INOUT' THEN 2
		ELSE 0
	END
	  AS COLUMN_TYPE,
	P.DATA_TYPE AS TYPE_NAME,
	P.CHARACTER_MAXIMUM_LENGTH AS LENGTH,
	P.NUMERIC_PRECISION AS PRECISION,
	P.NUMERIC_SCALE,
	P.ORDINAL_POSITION,
	-1 AS DATA_TYPE,
	NULL AS REMARKS
FROM
	INFORMATION_SCHEMA.PARAMETERS P
	INNER JOIN INFORMATION_SCHEMA.ROUTINES R
		ON P.SPECIFIC_NAME = R.SPECIFIC_NAME
			AND P.SPECIFIC_SCHEMA = R.SPECIFIC_SCHEMA
WHERE
	R.ROUTINE_TYPE = 'FUNCTION'
	AND R.ROUTINE_SCHEMA = '${schema-name}'
