% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.edit-functions.R
\name{rk.edit}
\alias{rk.edit}
\alias{rk.edit.files}
\alias{rk.show.files}
\alias{rk.show.html}
\alias{rk.show.pdf}
\title{Edit / show an object / file}
\usage{
rk.edit(x)

rk.edit.files(name, file = "", title, prompt = TRUE)

rk.show.files(
  file = file,
  header = file,
  title,
  delete.file = FALSE,
  prompt = TRUE,
  delete = delete.file
)

rk.show.html(url, content)

rk.show.pdf(url)
}
\arguments{
\item{x}{an object to edit.}

\item{name}{name of the environment to use (optional).}

\item{file}{character vector, filenames to show or edit.}

\item{title}{character vector, of the same length as \code{file}; This can
be used to give descriptive titles to each file, which will be displayed
to the user.}

\item{prompt}{logical of length 1. If TRUE (the default) a prompt is dialog
is shown along with the files to show / edit.}

\item{header}{character, header to show.}

\item{delete.file}{a logical (not NA), when \code{TRUE} the shown file(s) are
deleted after closing.}

\item{delete}{logical, for compatibility with earlier versions of R.}

\item{url}{a URL to show.}
}
\value{
All functions described on this page return \code{NULL},
  unconditionally.
}
\description{
\code{rk.edit} can be used to edit an object in the RKWard data editor.
Currently only \link{data.frame}s are supported. This is similar to
\link{edit.data.frame}, but the function returns immediately, and the object
is edit asynchronously.
}
\details{
\code{rk.edit.files}, \code{rk.show.files}, and \code{rk.show.html} are
equivalent to \link{edit}, \link{file.show}, and \link{browseURL},
respectively, but use RKWard as text/html editor/viewer. Generally it is
recommended to use \link{edit}, \link{file.edit}, \link{file.show},
and \link{browseURL}, instead. These will call the respective RKWard functions
by default, when run inside an RKWard session. (via \code{getOption("editor")},
and \code{getOption("browser")}.

\code{rk.show.html} with \code{content}-argument, insed of \code{url}-argument, will
show the given HTML string. This is mostly useful for plugins, where it may be
desirable to show an error-message at the place where usually an HTML-file would
be shown.

\code{rk.show.pdf} opens a PDF (or postscript) document in a viewer window inside RKWard.
}
\examples{
\dontrun{
x <- data.frame (a=c(1:3), b=c(2:4))
rk.edit(x)
}
}
\seealso{
\code{\link{edit}}, \code{\link{file.edit}},
  \code{\link{file.show}}, \code{\link{browseURL}}
}
\author{
Thomas Friedrichsmeier \email{rkward-devel@kde.org}
}
\keyword{IO}
\keyword{utilities}
