from collections.abc import Iterable
from typing import ClassVar

from .core import Calendar

class IsoRegistry:
    STANDARD_MODULES: ClassVar[tuple[str, ...]]
    region_registry: dict[str, type[Calendar]]
    def __init__(self, load_standard_modules: bool | None = True) -> None: ...
    def register(self, iso_code: str, cls: type[Calendar]) -> None: ...
    def load_module_from_items(self, module_name: str, items: Iterable[str]) -> None: ...
    def get(self, iso_code: str) -> type[Calendar]: ...
    def get_subregions(self, iso_code: str) -> dict[str, type[Calendar]]: ...
    def get_calendars(
        self, region_codes: Iterable[str] | None = None, include_subregions: bool | None = False
    ) -> dict[str, type[Calendar]]: ...

registry: IsoRegistry
