/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.floats.FloatComparator;
import java.io.Serializable;

public final class FloatArrays {
    public static final float[] EMPTY_ARRAY = new float[0];
    public static final float[] DEFAULT_EMPTY_ARRAY = new float[0];
    protected static final Segment POISON_PILL = new Segment(-1, -1, -1);
    public static final Hash.Strategy<float[]> HASH_STRATEGY = new ArrayHashStrategy();

    public static float[] forceCapacity(float[] array, int length, int preserve) {
        float[] t = new float[length];
        System.arraycopy(array, 0, t, 0, preserve);
        return t;
    }

    public static float[] ensureCapacity(float[] array, int length, int preserve) {
        return length > array.length ? FloatArrays.forceCapacity(array, length, preserve) : array;
    }

    public static void ensureOffsetLength(float[] a, int offset, int length) {
        Arrays.ensureOffsetLength(a.length, offset, length);
    }

    public static void swap(float[] x, int a, int b) {
        float t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    public static void swap(float[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            FloatArrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(float[] x, int a, int b, int c, FloatComparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(float[] a, int from, int to, FloatComparator comp) {
        for (int i = from; i < to - 1; ++i) {
            int m = i;
            for (int j = i + 1; j < to; ++j) {
                if (comp.compare(a[j], a[m]) >= 0) continue;
                m = j;
            }
            if (m == i) continue;
            float u = a[i];
            a[i] = a[m];
            a[m] = u;
        }
    }

    private static void insertionSort(float[] a, int from, int to, FloatComparator comp) {
        int i = from;
        while (++i < to) {
            float t = a[i];
            int j = i;
            float u = a[j - 1];
            while (comp.compare(t, u) < 0) {
                a[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }

    public static void quickSort(float[] x, int from, int to, FloatComparator comp) {
        int c;
        int a;
        int len = to - from;
        if (len < 16) {
            FloatArrays.selectionSort(x, from, to, comp);
            return;
        }
        int m = from + len / 2;
        int l = from;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = FloatArrays.med3(x, l, l + s, l + 2 * s, comp);
            m = FloatArrays.med3(x, m - s, m, m + s, comp);
            n = FloatArrays.med3(x, n - 2 * s, n - s, n, comp);
        }
        m = FloatArrays.med3(x, l, m, n, comp);
        float v = x[m];
        int b = a = from;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    FloatArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    FloatArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            FloatArrays.swap(x, b++, c--);
        }
        int s = Math.min(a - from, b - a);
        FloatArrays.swap(x, from, b - s, s);
        s = Math.min(d - c, to - d - 1);
        FloatArrays.swap(x, b, to - s, s);
        s = b - a;
        if (s > 1) {
            FloatArrays.quickSort(x, from, from + s, comp);
        }
        if ((s = d - c) > 1) {
            FloatArrays.quickSort(x, to - s, to, comp);
        }
    }

    private static int med3(float[] x, int a, int b, int c) {
        int ab = Float.compare(x[a], x[b]);
        int ac = Float.compare(x[a], x[c]);
        int bc = Float.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(float[] a, int from, int to) {
        for (int i = from; i < to - 1; ++i) {
            int m = i;
            for (int j = i + 1; j < to; ++j) {
                if (Float.compare(a[j], a[m]) >= 0) continue;
                m = j;
            }
            if (m == i) continue;
            float u = a[i];
            a[i] = a[m];
            a[m] = u;
        }
    }

    private static void insertionSort(float[] a, int from, int to) {
        int i = from;
        while (++i < to) {
            float t = a[i];
            int j = i;
            float u = a[j - 1];
            while (Float.compare(t, u) < 0) {
                a[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }

    public static void quickSort(float[] x, int from, int to) {
        int c;
        int a;
        int len = to - from;
        if (len < 16) {
            FloatArrays.selectionSort(x, from, to);
            return;
        }
        int m = from + len / 2;
        int l = from;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = FloatArrays.med3(x, l, l + s, l + 2 * s);
            m = FloatArrays.med3(x, m - s, m, m + s);
            n = FloatArrays.med3(x, n - 2 * s, n - s, n);
        }
        m = FloatArrays.med3(x, l, m, n);
        float v = x[m];
        int b = a = from;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = Float.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    FloatArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = Float.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    FloatArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            FloatArrays.swap(x, b++, c--);
        }
        int s = Math.min(a - from, b - a);
        FloatArrays.swap(x, from, b - s, s);
        s = Math.min(d - c, to - d - 1);
        FloatArrays.swap(x, b, to - s, s);
        s = b - a;
        if (s > 1) {
            FloatArrays.quickSort(x, from, from + s);
        }
        if ((s = d - c) > 1) {
            FloatArrays.quickSort(x, to - s, to);
        }
    }

    public static void unstableSort(float[] a, int from, int to) {
        if (to - from >= 2000) {
            FloatArrays.radixSort(a, from, to);
        } else {
            FloatArrays.quickSort(a, from, to);
        }
    }

    public static void unstableSort(float[] a) {
        FloatArrays.unstableSort(a, 0, a.length);
    }

    public static void unstableSort(float[] a, int from, int to, FloatComparator comp) {
        FloatArrays.quickSort(a, from, to, comp);
    }

    public static void unstableSort(float[] a, FloatComparator comp) {
        FloatArrays.unstableSort(a, 0, a.length, comp);
    }

    public static void mergeSort(float[] a, int from, int to, float[] supp) {
        int len = to - from;
        if (len < 16) {
            FloatArrays.insertionSort(a, from, to);
            return;
        }
        if (supp == null) {
            supp = java.util.Arrays.copyOf(a, to);
        }
        int mid = from + to >>> 1;
        FloatArrays.mergeSort(supp, from, mid, a);
        FloatArrays.mergeSort(supp, mid, to, a);
        if (Float.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, a, from, len);
            return;
        }
        int p = from;
        int q = mid;
        for (int i = from; i < to; ++i) {
            a[i] = q >= to || p < mid && Float.compare(supp[p], supp[q]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(float[] a, int from, int to) {
        FloatArrays.mergeSort(a, from, to, (float[])null);
    }

    public static void mergeSort(float[] a, int from, int to, FloatComparator comp, float[] supp) {
        int len = to - from;
        if (len < 16) {
            FloatArrays.insertionSort(a, from, to, comp);
            return;
        }
        if (supp == null) {
            supp = java.util.Arrays.copyOf(a, to);
        }
        int mid = from + to >>> 1;
        FloatArrays.mergeSort(supp, from, mid, comp, a);
        FloatArrays.mergeSort(supp, mid, to, comp, a);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, a, from, len);
            return;
        }
        int p = from;
        int q = mid;
        for (int i = from; i < to; ++i) {
            a[i] = q >= to || p < mid && comp.compare(supp[p], supp[q]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(float[] a, int from, int to, FloatComparator comp) {
        FloatArrays.mergeSort(a, from, to, comp, null);
    }

    public static void stableSort(float[] a, int from, int to) {
        FloatArrays.mergeSort(a, from, to);
    }

    public static void stableSort(float[] a) {
        FloatArrays.stableSort(a, 0, a.length);
    }

    public static void stableSort(float[] a, int from, int to, FloatComparator comp) {
        FloatArrays.mergeSort(a, from, to, comp);
    }

    public static void stableSort(float[] a, FloatComparator comp) {
        FloatArrays.stableSort(a, 0, a.length, comp);
    }

    private static final int fixFloat(float f) {
        int i = Float.floatToRawIntBits(f);
        return i >= 0 ? i : i ^ Integer.MAX_VALUE;
    }

    public static void radixSort(float[] a, int from, int to) {
        if (to - from < 1024) {
            FloatArrays.quickSort(a, from, to);
            return;
        }
        int maxLevel = 3;
        int stackSize = 766;
        int stackPos = 0;
        int[] offsetStack = new int[766];
        int[] lengthStack = new int[766];
        int[] levelStack = new int[766];
        offsetStack[stackPos] = from;
        lengthStack[stackPos] = to - from;
        levelStack[stackPos++] = 0;
        int[] count = new int[256];
        int[] pos = new int[256];
        while (stackPos > 0) {
            int first = offsetStack[--stackPos];
            int length = lengthStack[stackPos];
            int level = levelStack[stackPos];
            int signMask = level % 4 == 0 ? 128 : 0;
            int shift = (3 - level % 4) * 8;
            int i = first + length;
            while (i-- != first) {
                int n = FloatArrays.fixFloat(a[i]) >>> shift & 0xFF ^ signMask;
                count[n] = count[n] + 1;
            }
            int lastUsed = -1;
            int p = first;
            for (int i2 = 0; i2 < 256; ++i2) {
                if (count[i2] != 0) {
                    lastUsed = i2;
                }
                pos[i2] = p += count[i2];
            }
            int end = first + length - count[lastUsed];
            int c = -1;
            for (int i3 = first; i3 <= end; i3 += count[c]) {
                float t = a[i3];
                c = FloatArrays.fixFloat(t) >>> shift & 0xFF ^ signMask;
                if (i3 < end) {
                    while (true) {
                        int n = c;
                        int n2 = pos[n] - 1;
                        pos[n] = n2;
                        int d = n2;
                        if (n2 <= i3) break;
                        float z = t;
                        t = a[d];
                        a[d] = z;
                        c = FloatArrays.fixFloat(t) >>> shift & 0xFF ^ signMask;
                    }
                    a[i3] = t;
                }
                if (level < 3 && count[c] > 1) {
                    if (count[c] < 1024) {
                        FloatArrays.quickSort(a, i3, i3 + count[c]);
                    } else {
                        offsetStack[stackPos] = i3;
                        lengthStack[stackPos] = count[c];
                        levelStack[stackPos++] = level + 1;
                    }
                }
                count[c] = 0;
            }
        }
    }

    protected static final class Segment {
        protected final int offset;
        protected final int length;
        protected final int level;

        protected Segment(int offset, int length, int level) {
            this.offset = offset;
            this.length = length;
            this.level = level;
        }

        public String toString() {
            return "Segment [offset=" + this.offset + ", length=" + this.length + ", level=" + this.level + "]";
        }
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<float[]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(float[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(float[] a, float[] b) {
            return java.util.Arrays.equals(a, b);
        }
    }
}

