/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.copyright;

import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.psi.PyFile;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001H\u0002\"\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"first", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/jetbrains/python/psi/PyFile;", "isShebangComment", "", "element", "shebang", "skipWhitespaceForwardNotNull", "e", "ENCODING_PATTERN", "Ljava/util/function/Predicate;", "", "isEncodingComment", "coding", "intellij.python.copyright"})
public final class PyCopyrightKt {
    @NotNull
    private static final Predicate<String> ENCODING_PATTERN;

    private static final PsiElement first(PyFile file) {
        PsiElement psiElement = file.getFirstChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getFirstChild(...)");
        return PyCopyrightKt.coding(PyCopyrightKt.shebang(psiElement));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isShebangComment(PsiElement element) {
        if (!(element instanceof PsiComment)) return false;
        String string = ((PsiComment)element).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (!StringsKt.startsWith$default((String)string, (String)"#!", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private static final PsiElement shebang(PsiElement element) {
        PsiElement psiElement;
        if (PyCopyrightKt.isShebangComment(element)) {
            PsiElement psiElement2 = element.getNextSibling();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getNextSibling(...)");
            psiElement = PyCopyrightKt.skipWhitespaceForwardNotNull(psiElement2);
        } else {
            psiElement = element;
        }
        return psiElement;
    }

    private static final PsiElement skipWhitespaceForwardNotNull(PsiElement e) {
        PsiElement psiElement = PsiTreeUtil.skipWhitespacesForward((PsiElement)e);
        if (psiElement == null) {
            psiElement = e;
        }
        return psiElement;
    }

    private static final boolean isEncodingComment(PsiElement element) {
        return element instanceof PsiComment && ENCODING_PATTERN.test(((PsiComment)element).getText());
    }

    private static final PsiElement coding(PsiElement element) {
        PsiElement psiElement;
        if (PyCopyrightKt.isEncodingComment(element)) {
            PsiElement psiElement2 = element.getNextSibling();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getNextSibling(...)");
            psiElement = PyCopyrightKt.skipWhitespaceForwardNotNull(psiElement2);
        } else {
            psiElement = element;
        }
        return psiElement;
    }

    public static final /* synthetic */ PsiElement access$first(PyFile file) {
        return PyCopyrightKt.first(file);
    }

    static {
        Predicate<String> predicate = Pattern.compile("^[ \\t\\f]*#.*?coding[:=][ \\t]*([-_.a-zA-Z0-9]+)").asPredicate();
        Intrinsics.checkNotNullExpressionValue(predicate, (String)"asPredicate(...)");
        ENCODING_PATTERN = predicate;
    }
}

