/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.combined.search;

import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.find.EditorSearchSession;
import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.find.FindUtil;
import com.intellij.find.SearchReplaceComponent;
import com.intellij.find.SearchSession;
import com.intellij.find.editorHeaderActions.NextOccurrenceAction;
import com.intellij.find.editorHeaderActions.PrevOccurrenceAction;
import com.intellij.find.editorHeaderActions.RestorePreviousSettingsAction;
import com.intellij.find.editorHeaderActions.StatusTextAction;
import com.intellij.find.editorHeaderActions.ToggleMatchCase;
import com.intellij.find.editorHeaderActions.TogglePreserveCaseAction;
import com.intellij.find.editorHeaderActions.ToggleRegex;
import com.intellij.find.editorHeaderActions.ToggleWholeWordsOnlyAction;
import com.intellij.find.impl.livePreview.SearchResults;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diff.impl.combined.search.CombinedEditorSearchSession;
import com.intellij.openapi.diff.impl.combined.search.CombinedEditorSearchSessionListener;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.ex.EditorEventMulticasterEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\bRSTUVWXYB5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0013\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0002\u00a2\u0006\u0002\u0010)J\u000e\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020$J>\u0010,\u001a\u00020\t\"\u0004\b\u0000\u0010-2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H-0\u001e2\u0018\u0010/\u001a\u0014\u0012\u0004\u0012\u0002H-\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u001e002\b\b\u0002\u0010\u0005\u001a\u00020\u0006J\b\u00101\u001a\u00020\tH\u0002J\u0010\u00102\u001a\u00020\t2\u0006\u00103\u001a\u00020\u0006H\u0002J\u0018\u00102\u001a\u00020\t2\u0006\u00104\u001a\u00020\u001a2\u0006\u00105\u001a\u00020\u001cH\u0002J\b\u00106\u001a\u00020\tH\u0002J\b\u00107\u001a\u00020\tH\u0002J\u001c\u00108\u001a\u00020\t*\u00020\u00182\u0006\u00109\u001a\u00020\u001a2\u0006\u0010:\u001a\u00020;H\u0002J\u0018\u0010<\u001a\u00020\t2\u0010\u0010=\u001a\f0>\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\b?J\b\u0010@\u001a\u00020\u0014H\u0016J\b\u0010A\u001a\u00020\u0018H\u0016J\b\u0010B\u001a\u00020;H\u0016J\b\u0010C\u001a\u00020;H\u0016J\b\u0010D\u001a\u00020\tH\u0016J\b\u0010E\u001a\u00020\tH\u0016J$\u0010F\u001a\u00020\t2\u0006\u0010G\u001a\u00020;2\b\b\u0002\u0010H\u001a\u00020\u001a2\b\b\u0002\u0010I\u001a\u00020\u001cH\u0002J\u0014\u0010F\u001a\u00020\t*\u00020!2\u0006\u0010G\u001a\u00020;H\u0002J\f\u0010J\u001a\u00020\t*\u00020!H\u0002J\f\u0010K\u001a\u00020\t*\u00020!H\u0002J\f\u0010L\u001a\u00020;*\u00020!H\u0002J\u0014\u0010M\u001a\u00020;*\u00020!2\u0006\u0010G\u001a\u00020;H\u0002J\b\u0010N\u001a\u00020\tH\u0016J\u0010\u0010O\u001a\u00020\t2\u0006\u0010P\u001a\u00020QH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u00060\u0016R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001d\u001a\f\u0012\b\u0012\u00060\u001fR\u00020\u00000\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\"\u001a\u0015\u0012\f\u0012\n %*\u0004\u0018\u00010$0$0#\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lcom/intellij/openapi/diff/impl/combined/search/CombinedEditorSearchSession;", "Lcom/intellij/find/SearchSession;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "currentEditor", "Lcom/intellij/openapi/editor/Editor;", "closeAction", "Lkotlin/Function0;", "", "parentComponent", "Ljavax/swing/JComponent;", "disposableParent", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lkotlin/jvm/functions/Function0;Ljavax/swing/JComponent;Lcom/intellij/openapi/Disposable;)V", "disposable", "Lcom/intellij/openapi/util/CheckedDisposable;", "Lorg/jetbrains/annotations/NotNull;", "findModel", "Lcom/intellij/find/FindModel;", "modelObserver", "Lcom/intellij/openapi/diff/impl/combined/search/CombinedEditorSearchSession$FindModelObserver;", "searchComponent", "Lcom/intellij/find/SearchReplaceComponent;", "currentSessionIndex", "", "currentSessionPosition", "Lcom/intellij/openapi/diff/impl/combined/search/CombinedEditorSearchSession$Position;", "holders", "", "Lcom/intellij/openapi/diff/impl/combined/search/CombinedEditorSearchSession$EditorSearchSessionHolder;", "currentSession", "Lcom/intellij/find/EditorSearchSession;", "listeners", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/openapi/diff/impl/combined/search/CombinedEditorSearchSessionListener;", "kotlin.jvm.PlatformType", "createPrimarySearchActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "()[Lcom/intellij/openapi/actionSystem/AnAction;", "addListener", "listener", "update", "EditorHolder", "items", "mapper", "Lkotlin/Function1;", "registerEditorsFocusListener", "updateCurrentState", "newCurrentEditor", "sessionIndex", "sessionPosition", "updateResults", "nothingToSearchFor", "updateUIWithResults", "matches", "regularBackground", "", "setStatusText", "status", "", "Lcom/intellij/openapi/util/NlsContexts$Label;", "getFindModel", "getComponent", "hasMatches", "isSearchInProgress", "searchForward", "searchBackward", "search", "forward", "curSessionIdx", "curSessionPosition", "moveCaretToStart", "moveCaretToEnd", "hasSingleOccurence", "canSearch", "close", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "EditorSearchSessionHolder", "Position", "FindModelObserver", "MyEditorFocusListener", "MySearchComponentListener", "MySearchResultsListener", "WiderStatusTextAction", "EditorSearchSessionEx", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nCombinedEditorSearchSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CombinedEditorSearchSession.kt\ncom/intellij/openapi/diff/impl/combined/search/CombinedEditorSearchSession\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,404:1\n37#2,2:405\n1869#3,2:407\n1869#3,2:409\n1869#3,2:411\n1869#3,2:413\n1761#3,3:415\n1761#3,3:418\n1869#3,2:421\n1#4:423\n*S KotlinDebug\n*F\n+ 1 CombinedEditorSearchSession.kt\ncom/intellij/openapi/diff/impl/combined/search/CombinedEditorSearchSession\n*L\n107#1:405,2\n118#1:407,2\n137#1:409,2\n210#1:411,2\n232#1:413,2\n254#1:415,3\n258#1:418,3\n329#1:421,2\n*E\n"})
public final class CombinedEditorSearchSession
implements SearchSession,
UiDataProvider {
    @NotNull
    private final Project project;
    @NotNull
    private Editor currentEditor;
    @NotNull
    private final Function0<Unit> closeAction;
    @NotNull
    private final CheckedDisposable disposable;
    @NotNull
    private FindModel findModel;
    @NotNull
    private final FindModelObserver modelObserver;
    @NotNull
    private final SearchReplaceComponent searchComponent;
    private int currentSessionIndex;
    @NotNull
    private Position currentSessionPosition;
    @NotNull
    private List<EditorSearchSessionHolder> holders;
    @NotNull
    private EditorSearchSession currentSession;
    @NotNull
    private final EventDispatcher<CombinedEditorSearchSessionListener> listeners;

    /*
     * WARNING - void declaration
     */
    public CombinedEditorSearchSession(@NotNull Project project, @NotNull Editor currentEditor, @NotNull Function0<Unit> closeAction, @NotNull JComponent parentComponent, @NotNull Disposable disposableParent) {
        void it;
        AnAction[] anActionArray;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)currentEditor, (String)"currentEditor");
        Intrinsics.checkNotNullParameter(closeAction, (String)"closeAction");
        Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
        Intrinsics.checkNotNullParameter((Object)disposableParent, (String)"disposableParent");
        this.project = project;
        this.currentEditor = currentEditor;
        this.closeAction = closeAction;
        AnAction[] anActionArray2 = anActionArray = Disposer.newCheckedDisposable();
        CombinedEditorSearchSession combinedEditorSearchSession = this;
        boolean bl = false;
        Disposer.register((Disposable)((Disposable)it), this::close);
        Disposer.register((Disposable)disposableParent, (Disposable)((Disposable)it));
        Intrinsics.checkNotNullExpressionValue((Object)anActionArray, (String)"also(...)");
        combinedEditorSearchSession.disposable = anActionArray;
        FindModel findModel = EditorSearchSession.createDefaultFindModel((Project)this.project, (Editor)this.currentEditor);
        Intrinsics.checkNotNullExpressionValue((Object)findModel, (String)"createDefaultFindModel(...)");
        this.findModel = findModel;
        this.modelObserver = new FindModelObserver();
        this.currentSessionPosition = Position.FIRST;
        this.holders = CollectionsKt.emptyList();
        this.currentSession = new EditorSearchSessionEx(this.currentEditor, this.project, this.findModel, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                ((CombinedEditorSearchSession)this.receiver).close();
            }
        }));
        EventDispatcher eventDispatcher = EventDispatcher.create(CombinedEditorSearchSessionListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.listeners = eventDispatcher;
        anActionArray = this.createPrimarySearchActions();
        SearchReplaceComponent.Builder builder = SearchReplaceComponent.buildFor((Project)this.project, (JComponent)parentComponent, (SearchSession)this).addPrimarySearchActions(Arrays.copyOf(anActionArray, anActionArray.length));
        anActionArray = new AnAction[]{new ToggleMatchCase(), new ToggleWholeWordsOnlyAction(), new ToggleRegex()};
        SearchReplaceComponent.Builder builder2 = builder.addExtraSearchActions(anActionArray);
        anActionArray = new AnAction[]{new RestorePreviousSettingsAction()};
        SearchReplaceComponent.Builder builder3 = builder2.addSearchFieldActions(anActionArray);
        anActionArray = new AnAction[]{new TogglePreserveCaseAction()};
        SearchReplaceComponent.Builder builder4 = builder3.addExtraReplaceAction(anActionArray);
        anActionArray = new AnAction[]{new PrevOccurrenceAction(false), new NextOccurrenceAction(false)};
        SearchReplaceComponent searchReplaceComponent = builder4.addReplaceFieldActions(anActionArray).withCloseAction(this::close).build();
        Intrinsics.checkNotNullExpressionValue((Object)searchReplaceComponent, (String)"build(...)");
        this.searchComponent = searchReplaceComponent;
        this.searchComponent.addListener((SearchReplaceComponent.Listener)new MySearchComponentListener());
        this.registerEditorsFocusListener();
        UiNotifyConnector.Companion.installOn((Component)this.searchComponent, new Activatable(){

            public void showNotify() {
                Iterable $this$forEach$iv = holders;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    EditorSearchSessionHolder it = (EditorSearchSessionHolder)element$iv;
                    boolean bl = false;
                    it.initLivePreview();
                }
            }

            public void hideNotify() {
                Iterable $this$forEach$iv = holders;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    EditorSearchSessionHolder it = (EditorSearchSessionHolder)element$iv;
                    boolean bl = false;
                    it.disableLivePreview();
                }
            }
        });
    }

    private final AnAction[] createPrimarySearchActions() {
        AnAction[] anActionArray = EditorSearchSession.createPrimarySearchActions();
        Intrinsics.checkNotNullExpressionValue((Object)anActionArray, (String)"createPrimarySearchActions(...)");
        Collection $this$toTypedArray$iv = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])anActionArray), CombinedEditorSearchSession::createPrimarySearchActions$lambda$0));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new AnAction[0]);
    }

    public final void addListener(@NotNull CombinedEditorSearchSessionListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.addListener((EventListener)listener2, (Disposable)this.disposable);
    }

    /*
     * WARNING - void declaration
     */
    public final <EditorHolder> void update(@NotNull List<? extends EditorHolder> items, @NotNull Function1<? super EditorHolder, ? extends List<? extends Editor>> mapper, @NotNull Editor currentEditor) {
        void $this$update_u24lambda_u240;
        EditorSearchSessionHolder p0;
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)currentEditor, (String)"currentEditor");
        boolean emptyUpdate = items.isEmpty();
        boolean update2 = !((Collection)this.holders).isEmpty() || !emptyUpdate;
        Iterable $this$forEach$iv = this.holders;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            p0 = (EditorSearchSessionHolder)element$iv;
            boolean bl = false;
            p0.disposeLivePreview();
        }
        Iterable $i$f$forEach22 = $this$forEach$iv = new FindModel();
        CombinedEditorSearchSession combinedEditorSearchSession = this;
        boolean bl = false;
        $this$update_u24lambda_u240.copyFrom(this.findModel);
        $this$update_u24lambda_u240.addObserver((FindModel.FindModelObserver)this.modelObserver);
        combinedEditorSearchSession.findModel = $this$forEach$iv;
        this.holders = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)items), mapper), (Function1)update.3.INSTANCE), arg_0 -> CombinedEditorSearchSession.update$lambda$1(this, arg_0)));
        if (emptyUpdate) {
            this.updateUIWithResults(this.getComponent(), 0, false);
        } else {
            this.updateCurrentState(currentEditor);
        }
        if (update2) {
            $this$forEach$iv = this.holders;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                p0 = (EditorSearchSessionHolder)element$iv;
                boolean bl2 = false;
                p0.initLivePreview();
            }
            EditorSearchSession.updateEmptyText((SearchReplaceComponent)this.getComponent(), (FindModel)this.findModel, null);
        }
        EditorSearchSession.updateUIWithFindModel((SearchReplaceComponent)this.getComponent(), (FindModel)this.findModel, (Editor)(!emptyUpdate ? this.currentEditor : null));
    }

    public static /* synthetic */ void update$default(CombinedEditorSearchSession combinedEditorSearchSession, List list, Function1 function1, Editor editor, int n, Object object) {
        if ((n & 4) != 0) {
            editor = combinedEditorSearchSession.currentEditor;
        }
        combinedEditorSearchSession.update(list, function1, editor);
    }

    private final void registerEditorsFocusListener() {
        block0: {
            MyEditorFocusListener focusListener2 = new MyEditorFocusListener();
            EditorEventMulticaster editorEventMulticaster = EditorFactory.getInstance().getEventMulticaster();
            EditorEventMulticasterEx editorEventMulticasterEx = editorEventMulticaster instanceof EditorEventMulticasterEx ? (EditorEventMulticasterEx)editorEventMulticaster : null;
            if (editorEventMulticasterEx == null) break block0;
            editorEventMulticasterEx.addFocusChangeListener((FocusChangeListener)focusListener2, (Disposable)this.disposable);
        }
    }

    private final void updateCurrentState(Editor newCurrentEditor) {
        Iterator iterator = ((Iterable)this.holders).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int sessionIndex = n++;
            EditorSearchSessionHolder session = (EditorSearchSessionHolder)iterator.next();
            Position position = session.indexOf(newCurrentEditor);
            if (position == null) continue;
            Position newPosition = position;
            this.updateCurrentState(sessionIndex, newPosition);
            break;
        }
    }

    private final void updateCurrentState(int sessionIndex, Position sessionPosition) {
        EditorSearchSession editorSearchSession = this.holders.get(sessionIndex).getOrNull(sessionPosition);
        if (editorSearchSession == null) {
            return;
        }
        EditorSearchSession newCurSession = editorSearchSession;
        this.currentSessionPosition = sessionPosition;
        this.currentSessionIndex = sessionIndex;
        this.currentSession = newCurSession;
        Editor editor = newCurSession.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        this.currentEditor = editor;
    }

    private final void updateResults() {
        String text = this.findModel.getStringToFind();
        if (((CharSequence)text).length() == 0) {
            this.nothingToSearchFor();
            return;
        }
        if (this.findModel.isRegularExpressions()) {
            try {
                Pattern.compile(text);
            }
            catch (PatternSyntaxException e) {
                this.getComponent().setNotFoundBackground();
                Iterable $this$forEach$iv = this.holders;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    EditorSearchSessionHolder p0 = (EditorSearchSessionHolder)element$iv;
                    boolean bl = false;
                    p0.clearResults();
                }
                this.getComponent().setStatusText(FindBundle.message((String)"find.incorrect.regexp", (Object[])new Object[0]));
                return;
            }
            CharSequence charSequence = text;
            if (new Regex("\\|+").matches(charSequence)) {
                this.nothingToSearchFor();
                this.getComponent().setStatusText(ApplicationBundle.message((String)"editorsearch.empty.string.matches", (Object[])new Object[0]));
                return;
            }
        }
        FindManager findManager = FindManager.getInstance((Project)this.project);
        findManager.setFindWasPerformed();
        FindModel copy = new FindModel();
        copy.copyFrom(this.findModel);
        copy.setReplaceState(false);
        findManager.setFindNextModel(copy);
    }

    private final void nothingToSearchFor() {
        this.updateUIWithResults(this.getComponent(), 0, true);
        Iterable $this$forEach$iv = this.holders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditorSearchSessionHolder p0 = (EditorSearchSessionHolder)element$iv;
            boolean bl = false;
            p0.clearResults();
        }
    }

    private final void updateUIWithResults(SearchReplaceComponent $this$updateUIWithResults, int matches, boolean regularBackground) {
        if (regularBackground) {
            $this$updateUIWithResults.setRegularBackground();
        } else {
            $this$updateUIWithResults.setNotFoundBackground();
        }
        ((CombinedEditorSearchSessionListener)this.listeners.getMulticaster()).statusTextChanged(matches, this.holders.size());
    }

    public final void setStatusText(@NotNull String status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        this.getComponent().setStatusText(status);
    }

    @NotNull
    public FindModel getFindModel() {
        return this.findModel;
    }

    @NotNull
    public SearchReplaceComponent getComponent() {
        return this.searchComponent;
    }

    public boolean hasMatches() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.holders;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    EditorSearchSessionHolder p0 = (EditorSearchSessionHolder)element$iv;
                    boolean bl2 = false;
                    if (!p0.hasMatches()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public boolean isSearchInProgress() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.holders;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    EditorSearchSessionHolder p0 = (EditorSearchSessionHolder)element$iv;
                    boolean bl2 = false;
                    if (!p0.isSearchInProgress()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public void searchForward() {
        CombinedEditorSearchSession.search$default(this, true, 0, null, 6, null);
    }

    public void searchBackward() {
        CombinedEditorSearchSession.search$default(this, false, 0, null, 6, null);
    }

    private final void search(boolean forward, int curSessionIdx, Position curSessionPosition) {
        EditorSearchSession curSession = this.holders.get(curSessionIdx).getOrNull(curSessionPosition);
        if (curSession != null && this.canSearch(curSession, forward)) {
            this.search(curSession, forward);
            return;
        }
        int furtherIdx = curSessionIdx + (forward ? 1 : -1);
        if (!(0 <= furtherIdx ? furtherIdx < ((Collection)this.holders).size() : false)) {
            return;
        }
        curSession = this.holders.get(furtherIdx).getOrNull(curSessionPosition);
        if (curSession != null && curSession.hasMatches()) {
            CombinedEditorSearchSessionListener combinedEditorSearchSessionListener = (CombinedEditorSearchSessionListener)this.listeners.getMulticaster();
            Editor editor = curSession.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            combinedEditorSearchSessionListener.onSearch(forward, editor);
            if (forward) {
                this.moveCaretToStart(curSession);
            } else {
                this.moveCaretToEnd(curSession);
            }
            this.updateCurrentState(furtherIdx, curSessionPosition);
            if (this.canSearch(curSession, forward)) {
                this.search(curSession, forward);
            }
        } else {
            this.search(forward, furtherIdx, curSessionPosition);
        }
    }

    static /* synthetic */ void search$default(CombinedEditorSearchSession combinedEditorSearchSession, boolean bl, int n, Position position, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = combinedEditorSearchSession.currentSessionIndex;
        }
        if ((n2 & 4) != 0) {
            position = combinedEditorSearchSession.currentSessionPosition;
        }
        combinedEditorSearchSession.search(bl, n, position);
    }

    private final void search(EditorSearchSession $this$search, boolean forward) {
        if (forward) {
            $this$search.searchForward();
        } else {
            $this$search.searchBackward();
        }
    }

    private final void moveCaretToStart(EditorSearchSession $this$moveCaretToStart) {
        if ($this$moveCaretToStart.hasMatches()) {
            $this$moveCaretToStart.getEditor().getCaretModel().moveToOffset(0);
        }
    }

    private final void moveCaretToEnd(EditorSearchSession $this$moveCaretToEnd) {
        if ($this$moveCaretToEnd.hasMatches()) {
            $this$moveCaretToEnd.getEditor().getCaretModel().moveToOffset($this$moveCaretToEnd.getEditor().getDocument().getTextLength());
        }
    }

    private final boolean hasSingleOccurence(EditorSearchSession $this$hasSingleOccurence) {
        return $this$hasSingleOccurence.getSearchResults().getOccurrences().size() == 1;
    }

    private final boolean canSearch(EditorSearchSession $this$canSearch, boolean forward) {
        if (!$this$canSearch.hasMatches()) {
            return false;
        }
        if (this.hasSingleOccurence($this$canSearch) && $this$canSearch.getSearchResults().getOccurrenceAtCaret() != null) {
            return false;
        }
        FindResult firstOccurenceAroundCaret = forward ? $this$canSearch.getSearchResults().firstOccurrenceAfterCaret() : $this$canSearch.getSearchResults().firstOccurrenceBeforeCaret();
        return firstOccurenceAroundCaret != null;
    }

    public void close() {
        this.closeAction.invoke();
        Iterable $this$forEach$iv = this.holders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditorSearchSessionHolder p0 = (EditorSearchSessionHolder)element$iv;
            boolean bl = false;
            p0.close();
        }
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        DataSink.Companion.uiDataSnapshot(sink, (DataProvider)this.currentSession);
        DataKey dataKey = SearchSession.KEY;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"KEY");
        sink.set(dataKey, (Object)this);
    }

    private static final AnAction createPrimarySearchActions$lambda$0(AnAction action) {
        return action instanceof StatusTextAction ? (AnAction)new WiderStatusTextAction() : action;
    }

    private static final EditorSearchSessionHolder update$lambda$1(CombinedEditorSearchSession this$0, List editors) {
        EditorSearchSessionHolder editorSearchSessionHolder;
        Intrinsics.checkNotNullParameter((Object)editors, (String)"editors");
        EditorSearchSessionHolder holder = editorSearchSessionHolder = new EditorSearchSessionHolder(this$0, this$0.project, editors);
        boolean bl = false;
        holder.addResultListener(this$0.new MySearchResultsListener());
        return editorSearchSessionHolder;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\r\u001a\u00020\nH\u0016J\u0006\u0010\u000e\u001a\u00020\nJ\b\u0010\u000f\u001a\u00020\nH\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/diff/impl/combined/search/CombinedEditorSearchSession$EditorSearchSessionEx;", "Lcom/intellij/find/EditorSearchSession;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "findModel", "Lcom/intellij/find/FindModel;", "combinedSessionClose", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/project/Project;Lcom/intellij/find/FindModel;Lkotlin/jvm/functions/Function0;)V", "close", "closeSession", "disposeLivePreview", "intellij.platform.vcs.impl"})
    private static final class EditorSearchSessionEx
    extends EditorSearchSession {
        @NotNull
        private final Function0<Unit> combinedSessionClose;

        public EditorSearchSessionEx(@NotNull Editor editor, @NotNull Project project, @NotNull FindModel findModel, @NotNull Function0<Unit> combinedSessionClose) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)findModel, (String)"findModel");
            Intrinsics.checkNotNullParameter(combinedSessionClose, (String)"combinedSessionClose");
            super(editor, project, findModel);
            this.combinedSessionClose = combinedSessionClose;
        }

        public void close() {
            this.combinedSessionClose.invoke();
        }

        public final void closeSession() {
            this.disposeLivePreview();
        }

        public void disposeLivePreview() {
            super.disposeLivePreview();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\u0004\b\u0005\u0010\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\rJ\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010J\u0006\u0010\u0014\u001a\u00020\u0012J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0012J\u0006\u0010\u0019\u001a\u00020\u0012J\u0006\u0010\u001a\u001a\u00020\u0012J\u0006\u0010\u001b\u001a\u00020\u0012J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u0004\u0018\u00010\u001f2\u0006\u0010!\u001a\u00020\nR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/openapi/diff/impl/combined/search/CombinedEditorSearchSession$EditorSearchSessionHolder;", "", "sessions", "", "Lcom/intellij/openapi/diff/impl/combined/search/CombinedEditorSearchSession$EditorSearchSessionEx;", "<init>", "(Lcom/intellij/openapi/diff/impl/combined/search/CombinedEditorSearchSession;Ljava/util/List;)V", "project", "Lcom/intellij/openapi/project/Project;", "editors", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/diff/impl/combined/search/CombinedEditorSearchSession;Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "isSearchInProgress", "", "hasMatches", "getMatchesCount", "", "setMatchesLimit", "", "limit", "clearResults", "addResultListener", "listener", "Lcom/intellij/find/impl/livePreview/SearchResults$SearchResultsListener;", "initLivePreview", "disableLivePreview", "disposeLivePreview", "close", "getOrNull", "Lcom/intellij/find/EditorSearchSession;", "position", "Lcom/intellij/openapi/diff/impl/combined/search/CombinedEditorSearchSession$Position;", "indexOf", "editor", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nCombinedEditorSearchSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CombinedEditorSearchSession.kt\ncom/intellij/openapi/diff/impl/combined/search/CombinedEditorSearchSession$EditorSearchSessionHolder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,404:1\n1563#2:405\n1634#2,3:406\n1761#2,3:409\n1761#2,3:412\n1869#2,2:416\n1869#2,2:418\n1869#2,2:420\n1869#2,2:422\n1869#2,2:424\n1869#2,2:426\n1869#2,2:428\n360#2,7:430\n1#3:415\n*S KotlinDebug\n*F\n+ 1 CombinedEditorSearchSession.kt\ncom/intellij/openapi/diff/impl/combined/search/CombinedEditorSearchSession$EditorSearchSessionHolder\n*L\n55#1:405\n55#1:406,3\n57#1:409,3\n58#1:412,3\n60#1:416,2\n61#1:418,2\n62#1:420,2\n63#1:422,2\n64#1:424,2\n65#1:426,2\n66#1:428,2\n68#1:430,7\n*E\n"})
    private final class EditorSearchSessionHolder {
        @NotNull
        private final List<EditorSearchSessionEx> sessions;
        final /* synthetic */ CombinedEditorSearchSession this$0;

        public EditorSearchSessionHolder(@NotNull CombinedEditorSearchSession this$0, List<EditorSearchSessionEx> sessions) {
            Intrinsics.checkNotNullParameter(sessions, (String)"sessions");
            this.this$0 = this$0;
            this.sessions = sessions;
        }

        /*
         * WARNING - void declaration
         */
        public EditorSearchSessionHolder(@NotNull CombinedEditorSearchSession this$0, @NotNull Project project, List<? extends Editor> editors) {
            Collection<EditorSearchSessionEx> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(editors, (String)"editors");
            Iterable iterable = editors;
            CombinedEditorSearchSession combinedEditorSearchSession = this$0;
            EditorSearchSessionHolder editorSearchSessionHolder = this;
            boolean $i$f$map = false;
            void var6_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void editor;
                Editor editor2 = (Editor)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new EditorSearchSessionEx((Editor)editor, project, this$0.findModel, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this$0){

                    public final void invoke() {
                        ((CombinedEditorSearchSession)this.receiver).close();
                    }
                })));
            }
            collection = (List)destination$iv$iv;
            editorSearchSessionHolder(combinedEditorSearchSession, (List<EditorSearchSessionEx>)collection);
        }

        public final boolean isSearchInProgress() {
            boolean bl;
            block3: {
                Iterable $this$any$iv = this.sessions;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        EditorSearchSession p0 = (EditorSearchSession)element$iv;
                        boolean bl2 = false;
                        if (!p0.isSearchInProgress()) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public final boolean hasMatches() {
            boolean bl;
            block3: {
                Iterable $this$any$iv = this.sessions;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        EditorSearchSession p0 = (EditorSearchSession)element$iv;
                        boolean bl2 = false;
                        if (!p0.hasMatches()) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        public final int getMatchesCount() {
            Iterable iterable = this.sessions;
            int n = 0;
            for (Object t : iterable) {
                void session;
                EditorSearchSessionEx editorSearchSessionEx = (EditorSearchSessionEx)((Object)t);
                int n2 = n;
                boolean bl = false;
                int n3 = session.getSearchResults().getMatchesCount();
                n = n2 + n3;
            }
            return n;
        }

        public final void setMatchesLimit(int limit) {
            Iterable $this$forEach$iv = this.sessions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EditorSearchSessionEx session = (EditorSearchSessionEx)((Object)element$iv);
                boolean bl = false;
                session.getSearchResults().setMatchesLimit(limit);
            }
        }

        public final void clearResults() {
            Iterable $this$forEach$iv = this.sessions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EditorSearchSessionEx session = (EditorSearchSessionEx)((Object)element$iv);
                boolean bl = false;
                session.getSearchResults().clear();
            }
        }

        public final void addResultListener(@NotNull SearchResults.SearchResultsListener listener2) {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            Iterable $this$forEach$iv = this.sessions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EditorSearchSessionEx session = (EditorSearchSessionEx)((Object)element$iv);
                boolean bl = false;
                session.getSearchResults().addListener(listener2);
            }
        }

        public final void initLivePreview() {
            Iterable $this$forEach$iv = this.sessions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EditorSearchSession p0 = (EditorSearchSession)element$iv;
                boolean bl = false;
                p0.initLivePreview();
            }
        }

        public final void disableLivePreview() {
            Iterable $this$forEach$iv = this.sessions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EditorSearchSession p0 = (EditorSearchSession)element$iv;
                boolean bl = false;
                p0.disableLivePreview();
            }
        }

        public final void disposeLivePreview() {
            Iterable $this$forEach$iv = this.sessions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EditorSearchSessionEx p0 = (EditorSearchSessionEx)((Object)element$iv);
                boolean bl = false;
                p0.disposeLivePreview();
            }
        }

        public final void close() {
            Iterable $this$forEach$iv = this.sessions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EditorSearchSessionEx p0 = (EditorSearchSessionEx)((Object)element$iv);
                boolean bl = false;
                p0.closeSession();
            }
        }

        @Nullable
        public final EditorSearchSession getOrNull(@NotNull Position position) {
            Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
            return (EditorSearchSession)CollectionsKt.getOrNull(this.sessions, (int)position.getIndex());
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final Position indexOf(@NotNull Editor editor) {
            Object v1;
            block4: {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                Iterable iterable = (Iterable)Position.getEntries();
                for (Object t : iterable) {
                    int n;
                    int n2;
                    int n3;
                    block3: {
                        void $this$indexOfFirst$iv;
                        Position it = (Position)((Object)t);
                        boolean bl = false;
                        List<EditorSearchSessionEx> list = this.sessions;
                        n3 = it.getIndex();
                        boolean $i$f$indexOfFirst = false;
                        int index$iv = 0;
                        for (Object item$iv : $this$indexOfFirst$iv) {
                            EditorSearchSessionEx session = (EditorSearchSessionEx)((Object)item$iv);
                            boolean bl2 = false;
                            if (Intrinsics.areEqual((Object)session.getEditor(), (Object)editor)) {
                                n2 = index$iv;
                                break block3;
                            }
                            ++index$iv;
                        }
                        n2 = -1;
                    }
                    if (!(n3 == (n = n2))) continue;
                    v1 = t;
                    break block4;
                }
                v1 = null;
            }
            return v1;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/diff/impl/combined/search/CombinedEditorSearchSession$FindModelObserver;", "Lcom/intellij/find/FindModel$FindModelObserver;", "<init>", "(Lcom/intellij/openapi/diff/impl/combined/search/CombinedEditorSearchSession;)V", "updating", "", "getUpdating", "()Z", "setUpdating", "(Z)V", "findModelChanged", "", "model", "Lcom/intellij/find/FindModel;", "intellij.platform.vcs.impl"})
    private final class FindModelObserver
    implements FindModel.FindModelObserver {
        private boolean updating;

        public final boolean getUpdating() {
            return this.updating;
        }

        public final void setUpdating(boolean bl) {
            this.updating = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void findModelChanged(@NotNull FindModel model) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            if (this.updating) {
                return;
            }
            try {
                this.updating = true;
                EditorSearchSession.updateUIWithFindModel((SearchReplaceComponent)CombinedEditorSearchSession.this.getComponent(), (FindModel)model, (Editor)CombinedEditorSearchSession.this.currentEditor);
                CombinedEditorSearchSession.this.updateResults();
                FindUtil.updateFindInFileModel((Project)CombinedEditorSearchSession.this.project, (FindModel)model, (!ConsoleViewUtil.isConsoleViewEditor((Editor)CombinedEditorSearchSession.this.currentEditor) ? 1 : 0) != 0);
            }
            finally {
                this.updating = false;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0002\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/diff/impl/combined/search/CombinedEditorSearchSession$MyEditorFocusListener;", "Lcom/intellij/openapi/editor/ex/FocusChangeListener;", "<init>", "(Lcom/intellij/openapi/diff/impl/combined/search/CombinedEditorSearchSession;)V", "focusGained", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "changeCurrent", "newEditor", "intellij.platform.vcs.impl"})
    private final class MyEditorFocusListener
    implements FocusChangeListener {
        public void focusGained(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            this.changeCurrent(editor);
        }

        private final void changeCurrent(Editor newEditor) {
            if (!Intrinsics.areEqual((Object)newEditor, (Object)CombinedEditorSearchSession.this.currentEditor)) {
                CombinedEditorSearchSession.this.updateCurrentState(newEditor);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/diff/impl/combined/search/CombinedEditorSearchSession$MySearchComponentListener;", "Lcom/intellij/find/SearchReplaceComponent$Listener;", "<init>", "(Lcom/intellij/openapi/diff/impl/combined/search/CombinedEditorSearchSession;)V", "searchFieldDocumentChanged", "", "replaceFieldDocumentChanged", "multilineStateChanged", "toggleSearchReplaceMode", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nCombinedEditorSearchSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CombinedEditorSearchSession.kt\ncom/intellij/openapi/diff/impl/combined/search/CombinedEditorSearchSession$MySearchComponentListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,404:1\n1869#2,2:405\n1869#2,2:407\n*S KotlinDebug\n*F\n+ 1 CombinedEditorSearchSession.kt\ncom/intellij/openapi/diff/impl/combined/search/CombinedEditorSearchSession$MySearchComponentListener\n*L\n335#1:405,2\n344#1:407,2\n*E\n"})
    private final class MySearchComponentListener
    implements SearchReplaceComponent.Listener {
        /*
         * Unable to fully structure code
         */
        public void searchFieldDocumentChanged() {
            $this$forEach$iv = CombinedEditorSearchSession.access$getHolders$p(CombinedEditorSearchSession.this);
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                it = (EditorSearchSessionHolder)element$iv;
                $i$a$-forEach-CombinedEditorSearchSession$MySearchComponentListener$searchFieldDocumentChanged$1 = false;
                it.setMatchesLimit(10000);
            }
            text = CombinedEditorSearchSession.this.getComponent().getSearchTextComponent().getText();
            v0 = CombinedEditorSearchSession.access$getFindModel$p(CombinedEditorSearchSession.this);
            Intrinsics.checkNotNull((Object)text);
            v0.setStringToFind(text);
            CombinedEditorSearchSession.access$updateResults(CombinedEditorSearchSession.this);
            v1 = CombinedEditorSearchSession.access$getFindModel$p(CombinedEditorSearchSession.this);
            v2 = CombinedEditorSearchSession.this.getComponent().getSearchTextComponent().getText();
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getText(...)");
            if (StringsKt.contains$default((CharSequence)v2, (CharSequence)"\n", (boolean)false, (int)2, null)) ** GOTO lbl-1000
            v3 = CombinedEditorSearchSession.this.getComponent().getReplaceTextComponent().getText();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getText(...)");
            if (StringsKt.contains$default((CharSequence)v3, (CharSequence)"\n", (boolean)false, (int)2, null)) lbl-1000:
            // 2 sources

            {
                v4 = true;
            } else {
                v4 = false;
            }
            v1.setMultiline(v4);
        }

        /*
         * Unable to fully structure code
         */
        public void replaceFieldDocumentChanged() {
            $this$forEach$iv = CombinedEditorSearchSession.access$getHolders$p(CombinedEditorSearchSession.this);
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                it = (EditorSearchSessionHolder)element$iv;
                $i$a$-forEach-CombinedEditorSearchSession$MySearchComponentListener$replaceFieldDocumentChanged$1 = false;
                it.setMatchesLimit(10000);
            }
            v0 = CombinedEditorSearchSession.access$getFindModel$p(CombinedEditorSearchSession.this);
            v1 = CombinedEditorSearchSession.this.getComponent().getReplaceTextComponent().getText();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getText(...)");
            v0.setStringToReplace(v1);
            v2 = CombinedEditorSearchSession.access$getFindModel$p(CombinedEditorSearchSession.this);
            v3 = CombinedEditorSearchSession.this.getComponent().getSearchTextComponent().getText();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getText(...)");
            if (StringsKt.contains$default((CharSequence)v3, (CharSequence)"\n", (boolean)false, (int)2, null)) ** GOTO lbl-1000
            v4 = CombinedEditorSearchSession.this.getComponent().getReplaceTextComponent().getText();
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getText(...)");
            if (StringsKt.contains$default((CharSequence)v4, (CharSequence)"\n", (boolean)false, (int)2, null)) lbl-1000:
            // 2 sources

            {
                v5 = true;
            } else {
                v5 = false;
            }
            v2.setMultiline(v5);
        }

        public void multilineStateChanged() {
            CombinedEditorSearchSession.this.findModel.setMultiline(CombinedEditorSearchSession.this.getComponent().isMultiline());
        }

        public void toggleSearchReplaceMode() {
            CombinedEditorSearchSession.this.findModel.setReplaceState(!CombinedEditorSearchSession.this.findModel.isReplaceState());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/diff/impl/combined/search/CombinedEditorSearchSession$MySearchResultsListener;", "Lcom/intellij/find/impl/livePreview/SearchResults$SearchResultsListener;", "<init>", "(Lcom/intellij/openapi/diff/impl/combined/search/CombinedEditorSearchSession;)V", "searchResultsUpdated", "", "sr", "Lcom/intellij/find/impl/livePreview/SearchResults;", "cursorMoved", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nCombinedEditorSearchSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CombinedEditorSearchSession.kt\ncom/intellij/openapi/diff/impl/combined/search/CombinedEditorSearchSession$MySearchResultsListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,404:1\n1#2:405\n*E\n"})
    private final class MySearchResultsListener
    implements SearchResults.SearchResultsListener {
        /*
         * WARNING - void declaration
         */
        public void searchResultsUpdated(@NotNull SearchResults sr) {
            Intrinsics.checkNotNullParameter((Object)sr, (String)"sr");
            if (sr.getFindModel() == null) {
                return;
            }
            String string = CombinedEditorSearchSession.this.getComponent().getSearchTextComponent().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (((CharSequence)string).length() == 0) {
                CombinedEditorSearchSession.this.updateUIWithResults(CombinedEditorSearchSession.this.getComponent(), 0, true);
                return;
            }
            Iterable iterable = CombinedEditorSearchSession.this.holders;
            int n = 0;
            for (Object t : iterable) {
                void p0;
                EditorSearchSessionHolder editorSearchSessionHolder = (EditorSearchSessionHolder)t;
                int n2 = n;
                boolean bl = false;
                int n3 = p0.getMatchesCount();
                n = n2 + n3;
            }
            int matches = n;
            CombinedEditorSearchSession.this.updateUIWithResults(CombinedEditorSearchSession.this.getComponent(), matches, matches > 0);
            CombinedEditorSearchSession.this.getComponent().updateActions();
        }

        public void cursorMoved() {
            CombinedEditorSearchSession.this.getComponent().updateActions();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/diff/impl/combined/search/CombinedEditorSearchSession$Position;", "", "index", "", "<init>", "(Ljava/lang/String;II)V", "getIndex", "()I", "FIRST", "SECOND", "THIRD", "intellij.platform.vcs.impl"})
    private static final class Position
    extends Enum<Position> {
        private final int index;
        public static final /* enum */ Position FIRST = new Position(0);
        public static final /* enum */ Position SECOND = new Position(1);
        public static final /* enum */ Position THIRD = new Position(2);
        private static final /* synthetic */ Position[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Position(int index) {
            this.index = index;
        }

        public final int getIndex() {
            return this.index;
        }

        public static Position[] values() {
            return (Position[])$VALUES.clone();
        }

        public static Position valueOf(String value) {
            return Enum.valueOf(Position.class, value);
        }

        @NotNull
        public static EnumEntries<Position> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = positionArray = new Position[]{Position.FIRST, Position.SECOND, Position.THIRD};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/diff/impl/combined/search/CombinedEditorSearchSession$WiderStatusTextAction;", "Lcom/intellij/find/editorHeaderActions/StatusTextAction;", "<init>", "()V", "getTextToCountPreferredSize", "", "intellij.platform.vcs.impl"})
    private static final class WiderStatusTextAction
    extends StatusTextAction {
        @NotNull
        protected String getTextToCountPreferredSize() {
            return "9888 results in 100500 files";
        }
    }
}

