/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.ast.PyAstTypeParameter;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypeParameter;
import com.jetbrains.python.psi.PyTypeParameterList;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.validation.PyAnnotationHolder;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/validation/PyTypeParameterListAnnotatorVisitor;", "Lcom/jetbrains/python/psi/PyElementVisitor;", "holder", "Lcom/jetbrains/python/validation/PyAnnotationHolder;", "<init>", "(Lcom/jetbrains/python/validation/PyAnnotationHolder;)V", "visitPyTypeParameterList", "", "node", "Lcom/jetbrains/python/psi/PyTypeParameterList;", "visitPyTypeParameter", "Lcom/jetbrains/python/psi/PyTypeParameter;", "intellij.python.psi.impl"})
public final class PyTypeParameterListAnnotatorVisitor
extends PyElementVisitor {
    @NotNull
    private final PyAnnotationHolder holder;

    public PyTypeParameterListAnnotatorVisitor(@NotNull PyAnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
    }

    public void visitPyTypeParameterList(@NotNull PyTypeParameterList node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!node.getTypeParameters().isEmpty()) {
            Set namesSet = new LinkedHashSet();
            for (PyTypeParameter typeParameter : node.getTypeParameters()) {
                String name = typeParameter.getName();
                PsiElement identifier = typeParameter.getNameIdentifier();
                if (name == null || identifier == null || namesSet.add(name)) continue;
                Object[] objectArray = new Object[]{name};
                AnnotationBuilder annotationBuilder = this.holder.newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("type.param.list.annotator.type.parameter.already.defined", objectArray));
                PsiElement psiElement = typeParameter.getNameIdentifier();
                Intrinsics.checkNotNull((Object)psiElement);
                annotationBuilder.range(psiElement.getTextRange()).create();
            }
        }
    }

    public void visitPyTypeParameter(@NotNull PyTypeParameter node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        PyExpression boundExpression = PyPsiUtils.flattenParens((PyExpression)node.getBoundExpression());
        if (node.getKind() == PyAstTypeParameter.Kind.TypeVar) {
            if (boundExpression instanceof PyTupleExpression && ((PyTupleExpression)boundExpression).getElements().length < 2) {
                this.holder.newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("type.param.list.annotator.two.or.more.types.required", new Object[0])).range(((PyTupleExpression)boundExpression).getTextRange()).create();
            }
        } else if (boundExpression != null) {
            this.holder.newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("type.param.list.annotator.type.var.tuple.and.param.spec.can.not.have.bounds", new Object[0])).range(boundExpression.getTextRange()).create();
        }
    }
}

