/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.validation.PyAnnotationHolder;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class PyStringLiteralQuotesAnnotatorVisitor
extends PyElementVisitor {
    @NotNull
    private final PyAnnotationHolder myHolder;
    private static final String TRIPLE_QUOTES = "\"\"\"";
    private static final String TRIPLE_APOS = "'''";

    PyStringLiteralQuotesAnnotatorVisitor(@NotNull PyAnnotationHolder holder) {
        if (holder == null) {
            PyStringLiteralQuotesAnnotatorVisitor.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    public void visitPyStringLiteralExpression(@NotNull PyStringLiteralExpression node) {
        int index;
        String nodeText;
        String unprefixed;
        boolean foundError;
        ASTNode stringNode;
        if (node == null) {
            PyStringLiteralQuotesAnnotatorVisitor.$$$reportNull$$$0(1);
        }
        List stringNodes = node.getStringNodes();
        Iterator iterator = stringNodes.iterator();
        while (iterator.hasNext() && ((stringNode = (ASTNode)iterator.next()).getElementType() == PyElementTypes.FSTRING_NODE || !(foundError = StringUtil.startsWith((CharSequence)(unprefixed = (nodeText = PyPsiUtils.getElementTextWithoutHostEscaping((PsiElement)stringNode.getPsi())).substring(index = PyStringLiteralUtil.getPrefixLength((String)nodeText))), (CharSequence)TRIPLE_QUOTES) ? this.checkTripleQuotedString(stringNode, unprefixed, TRIPLE_QUOTES) : (StringUtil.startsWith((CharSequence)unprefixed, (CharSequence)TRIPLE_APOS) ? this.checkTripleQuotedString(stringNode, unprefixed, TRIPLE_APOS) : this.checkQuotedString(stringNode, unprefixed))))) {
        }
    }

    private boolean checkQuotedString(@NotNull ASTNode stringNode, @NotNull String nodeText) {
        if (stringNode == null) {
            PyStringLiteralQuotesAnnotatorVisitor.$$$reportNull$$$0(2);
        }
        if (nodeText == null) {
            PyStringLiteralQuotesAnnotatorVisitor.$$$reportNull$$$0(3);
        }
        char firstQuote = nodeText.charAt(0);
        char lastChar = nodeText.charAt(nodeText.length() - 1);
        int precedingBackslashCount = 0;
        for (int i = nodeText.length() - 2; i >= 0 && nodeText.charAt(i) == '\\'; --i) {
            ++precedingBackslashCount;
        }
        if (nodeText.length() == 1 || lastChar != firstQuote || precedingBackslashCount % 2 != 0) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("ANN.missing.closing.quote", Character.valueOf(firstQuote))).range(stringNode).create();
            return true;
        }
        return false;
    }

    private boolean checkTripleQuotedString(@NotNull ASTNode stringNode, @NotNull String text, @NotNull String quotes) {
        if (stringNode == null) {
            PyStringLiteralQuotesAnnotatorVisitor.$$$reportNull$$$0(4);
        }
        if (text == null) {
            PyStringLiteralQuotesAnnotatorVisitor.$$$reportNull$$$0(5);
        }
        if (quotes == null) {
            PyStringLiteralQuotesAnnotatorVisitor.$$$reportNull$$$0(6);
        }
        if (text.length() < 6 || !text.endsWith(quotes)) {
            int startOffset = StringUtil.trimTrailing((String)stringNode.getText()).lastIndexOf(10);
            startOffset = startOffset < 0 ? stringNode.getTextRange().getStartOffset() : stringNode.getTextRange().getStartOffset() + startOffset + 1;
            TextRange highlightRange = new TextRange(startOffset, stringNode.getTextRange().getEndOffset());
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("ANN.missing.closing.triple.quotes", new Object[0])).range(highlightRange).create();
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeText";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quotes";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/validation/PyStringLiteralQuotesAnnotatorVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyStringLiteralExpression";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkQuotedString";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTripleQuotedString";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

