/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogBuildParser;
import com.intellij.internal.statistic.eventLog.util.StringUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EventLogBuild
implements Comparable<EventLogBuild> {
    public static final int SNAPSHOT_VALUE = Integer.MAX_VALUE;
    @NotNull
    public static final EventLogBuildParser<EventLogBuild> EVENT_LOG_BUILD_PRODUCER = EventLogBuild::fromString;
    private final int[] myComponents;

    public EventLogBuild(int ... components) {
        this.myComponents = components;
    }

    public int[] getComponents() {
        return (int[])this.myComponents.clone();
    }

    @Nullable
    public static EventLogBuild fromString(@Nullable String version) {
        if (version == null || StringUtil.isEmptyOrSpaces(version)) {
            return null;
        }
        String versionWithoutCode = EventLogBuild.removeProductCode(version);
        int separator = versionWithoutCode.indexOf(46);
        if (separator > 0) {
            List<String> components = StringUtil.split(versionWithoutCode, '.');
            return new EventLogBuild(EventLogBuild.toIntArray(components));
        }
        return new EventLogBuild(EventLogBuild.tryParseInt(versionWithoutCode), 0);
    }

    private static int[] toIntArray(List<String> components) {
        int componentsSize = components.size();
        int size = componentsSize != 1 ? componentsSize : 2;
        int[] array = new int[size];
        for (int i2 = 0; i2 < componentsSize; ++i2) {
            String component = components.get(i2);
            array[i2] = EventLogBuild.tryParseInt(component);
        }
        if (componentsSize < size) {
            array[componentsSize] = 0;
        }
        return array;
    }

    @NotNull
    private static String removeProductCode(@NotNull String version) {
        String code = version;
        int productSeparator = code.indexOf(45);
        if (productSeparator > 0) {
            code = code.substring(productSeparator + 1);
        }
        return code;
    }

    private static int tryParseInt(@NotNull String version) {
        try {
            return Integer.parseInt(version);
        }
        catch (NumberFormatException e2) {
            return 0;
        }
    }

    @Override
    public int compareTo(@NotNull EventLogBuild o) {
        int[] c1 = this.myComponents;
        int[] c2 = o.myComponents;
        for (int i2 = 0; i2 < Math.min(c1.length, c2.length); ++i2) {
            if (c1[i2] == c2[i2] && c1[i2] == Integer.MAX_VALUE) {
                return 0;
            }
            if (c1[i2] == Integer.MAX_VALUE) {
                return 1;
            }
            if (c2[i2] == Integer.MAX_VALUE) {
                return -1;
            }
            int result2 = c1[i2] - c2[i2];
            if (result2 == 0) continue;
            return result2;
        }
        return c1.length - c2.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventLogBuild number = (EventLogBuild)o;
        return Arrays.equals(this.myComponents, number.myComponents);
    }

    public int hashCode() {
        return Arrays.hashCode(this.myComponents);
    }

    public String toString() {
        return Arrays.toString(this.myComponents);
    }
}

