/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.bundles;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.bundles.BundleReaderCoreKt;
import org.jetbrains.plugins.textmate.bundles.TextMateBundleReader;
import org.jetbrains.plugins.textmate.bundles.TextMateFileNameMatcher;
import org.jetbrains.plugins.textmate.bundles.TextMateGrammar;
import org.jetbrains.plugins.textmate.bundles.TextMatePreferences;
import org.jetbrains.plugins.textmate.bundles.TextMateResourceReader;
import org.jetbrains.plugins.textmate.language.PreferencesReadUtil;
import org.jetbrains.plugins.textmate.language.preferences.IndentationRules;
import org.jetbrains.plugins.textmate.language.preferences.TextMateAutoClosingPair;
import org.jetbrains.plugins.textmate.language.preferences.TextMateBracePair;
import org.jetbrains.plugins.textmate.language.preferences.TextMateShellVariable;
import org.jetbrains.plugins.textmate.language.preferences.TextMateSnippet;
import org.jetbrains.plugins.textmate.language.preferences.TextMateTextAttributes;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;
import org.jetbrains.plugins.textmate.plist.PlistReaderCore;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\u001a\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u001e\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a8\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012*\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00012\u0014\b\u0002\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00160\u0015H\u0002\u001a\"\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0001H\u0000*\n\u0010\u0000\"\u00020\u00012\u00020\u0001\u00a8\u0006\u001b"}, d2={"TextMateScopeName", "", "readTextMateBundle", "Lorg/jetbrains/plugins/textmate/bundles/TextMateBundleReader;", "fallbackBundleName", "plistReader", "Lorg/jetbrains/plugins/textmate/plist/PlistReaderCore;", "resourceReader", "Lorg/jetbrains/plugins/textmate/bundles/TextMateResourceReader;", "readSublimeBundle", "bundleName", "readSnippetFromPlist", "Lorg/jetbrains/plugins/textmate/language/preferences/TextMateSnippet;", "plist", "Lorg/jetbrains/plugins/textmate/plist/Plist;", "readPreferencesFromPlist", "Lorg/jetbrains/plugins/textmate/bundles/TextMatePreferences;", "readPlistInDirectory", "Lkotlin/sequences/Sequence;", "relativePath", "filter", "Lkotlin/Function1;", "", "readPlist", "bytes", "", "debugName", "intellij.textmate.core"})
@SourceDebugExtension(value={"SMAP\nBundleReaderCore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BundleReaderCore.kt\norg/jetbrains/plugins/textmate/bundles/BundleReaderCoreKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,182:1\n1#2:183\n1563#3:184\n1634#3,3:185\n1563#3:188\n1634#3,3:189\n*S KotlinDebug\n*F\n+ 1 BundleReaderCore.kt\norg/jetbrains/plugins/textmate/bundles/BundleReaderCoreKt\n*L\n138#1:184\n138#1:185,3\n142#1:188\n142#1:189,3\n*E\n"})
public final class BundleReaderCoreKt {
    @NotNull
    public static final TextMateBundleReader readTextMateBundle(@NotNull String fallbackBundleName, @NotNull PlistReaderCore plistReader, @NotNull TextMateResourceReader resourceReader) {
        Plist infoPlist;
        Object object;
        Plist plist;
        Intrinsics.checkNotNullParameter((Object)fallbackBundleName, (String)"fallbackBundleName");
        Intrinsics.checkNotNullParameter((Object)plistReader, (String)"plistReader");
        Intrinsics.checkNotNullParameter((Object)resourceReader, (String)"resourceReader");
        byte[] byArray = resourceReader.read("info.plist");
        if (byArray != null) {
            byte[] it = byArray;
            boolean bl = false;
            plist = plistReader.read(it);
        } else {
            plist = null;
        }
        String string = (object = (infoPlist = plist)) != null && (object = ((Plist)object).getPlistValue("name", fallbackBundleName)) != null ? ((PListValue)object).getString() : null;
        Intrinsics.checkNotNull(string);
        String bundleName = string;
        return new TextMateBundleReader(bundleName, resourceReader, plistReader){
            private final String bundleName;
            final /* synthetic */ TextMateResourceReader $resourceReader;
            final /* synthetic */ PlistReaderCore $plistReader;
            {
                this.$resourceReader = $resourceReader;
                this.$plistReader = $plistReader;
                this.bundleName = $bundleName;
            }

            public String getBundleName() {
                return this.bundleName;
            }

            public Sequence<TextMateGrammar> readGrammars() {
                return SequencesKt.map((Sequence)BundleReaderCoreKt.access$readPlistInDirectory(this.$resourceReader, this.$plistReader, "Syntaxes", readTextMateBundle.1::readGrammars$lambda$0), readTextMateBundle.1::readGrammars$lambda$1);
            }

            public Sequence<TextMatePreferences> readPreferences() {
                return SequencesKt.mapNotNull((Sequence)BundleReaderCoreKt.access$readPlistInDirectory(this.$resourceReader, this.$plistReader, "Preferences", readTextMateBundle.1::readPreferences$lambda$2), readTextMateBundle.1::readPreferences$lambda$3);
            }

            public Sequence<TextMateSnippet> readSnippets() {
                return SequencesKt.mapNotNull((Sequence)BundleReaderCoreKt.access$readPlistInDirectory(this.$resourceReader, this.$plistReader, "Snippets", readTextMateBundle.1::readSnippets$lambda$4), readTextMateBundle.1::readSnippets$lambda$5);
            }

            private static final boolean readGrammars$lambda$0(String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return StringsKt.endsWith$default((String)name, (String)".tmLanguage", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)".plist", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)".tmLanguage.json", (boolean)false, (int)2, null);
            }

            /*
             * WARNING - void declaration
             */
            private static final TextMateGrammar readGrammars$lambda$1(Plist plist) {
                void $this$flatMapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)plist, (String)"plist");
                Iterable $this$flatMap$iv = CollectionsKt.filterNotNull((Iterable)plist.getPlistValue("fileTypes", CollectionsKt.emptyList()).getStringArray());
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    String s = (String)element$iv$iv;
                    boolean bl = false;
                    Object[] objectArray = new TextMateFileNameMatcher[]{new TextMateFileNameMatcher.Name(s), new TextMateFileNameMatcher.Extension(s)};
                    Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List fileNameMatchers = (List)destination$iv$iv;
                PListValue pListValue = plist.getPlistValue("firstLineMatch");
                String firstLinePattern = pListValue != null ? pListValue.getString() : null;
                return new TextMateGrammar(fileNameMatchers, firstLinePattern, (Lazy<Plist>)LazyKt.lazy(() -> readTextMateBundle.1.readGrammars$lambda$1$1(plist)), null, null);
            }

            private static final Plist readGrammars$lambda$1$1(Plist $plist) {
                return $plist;
            }

            private static final boolean readPreferences$lambda$2(String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return StringsKt.endsWith$default((String)name, (String)".tmPreferences", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)".plist", (boolean)false, (int)2, null);
            }

            private static final TextMatePreferences readPreferences$lambda$3(Plist plist) {
                Intrinsics.checkNotNullParameter((Object)plist, (String)"plist");
                return BundleReaderCoreKt.access$readPreferencesFromPlist(plist);
            }

            private static final boolean readSnippets$lambda$4(String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return StringsKt.endsWith$default((String)name, (String)".tmSnippet", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)".plist", (boolean)false, (int)2, null);
            }

            private static final TextMateSnippet readSnippets$lambda$5(Plist plist) {
                Intrinsics.checkNotNullParameter((Object)plist, (String)"plist");
                return BundleReaderCoreKt.access$readSnippetFromPlist(plist);
            }
        };
    }

    @NotNull
    public static final TextMateBundleReader readSublimeBundle(@NotNull String bundleName, @NotNull PlistReaderCore plistReader, @NotNull TextMateResourceReader resourceReader) {
        Intrinsics.checkNotNullParameter((Object)bundleName, (String)"bundleName");
        Intrinsics.checkNotNullParameter((Object)plistReader, (String)"plistReader");
        Intrinsics.checkNotNullParameter((Object)resourceReader, (String)"resourceReader");
        return new TextMateBundleReader(bundleName, resourceReader, plistReader){
            private final String bundleName;
            final /* synthetic */ TextMateResourceReader $resourceReader;
            final /* synthetic */ PlistReaderCore $plistReader;
            {
                this.$resourceReader = $resourceReader;
                this.$plistReader = $plistReader;
                this.bundleName = $bundleName;
            }

            public String getBundleName() {
                return this.bundleName;
            }

            public Sequence<TextMateGrammar> readGrammars() {
                return SequencesKt.map((Sequence)BundleReaderCoreKt.access$readPlistInDirectory(this.$resourceReader, this.$plistReader, ".", readSublimeBundle.1::readGrammars$lambda$0), readSublimeBundle.1::readGrammars$lambda$1);
            }

            public Sequence<TextMatePreferences> readPreferences() {
                return SequencesKt.mapNotNull((Sequence)BundleReaderCoreKt.access$readPlistInDirectory(this.$resourceReader, this.$plistReader, ".", readSublimeBundle.1::readPreferences$lambda$2), readSublimeBundle.1::readPreferences$lambda$3);
            }

            public Sequence<TextMateSnippet> readSnippets() {
                return SequencesKt.mapNotNull((Sequence)BundleReaderCoreKt.access$readPlistInDirectory(this.$resourceReader, this.$plistReader, ".", readSublimeBundle.1::readSnippets$lambda$4), readSublimeBundle.1::readSnippets$lambda$5);
            }

            private static final boolean readGrammars$lambda$0(String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return StringsKt.endsWith$default((String)name, (String)".tmLanguage", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)".plist", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)".tmLanguage.json", (boolean)false, (int)2, null);
            }

            /*
             * WARNING - void declaration
             */
            private static final TextMateGrammar readGrammars$lambda$1(Plist plist) {
                void $this$flatMapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)plist, (String)"plist");
                Iterable $this$flatMap$iv = CollectionsKt.filterNotNull((Iterable)plist.getPlistValue("fileTypes", CollectionsKt.emptyList()).getStringArray());
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    String s = (String)element$iv$iv;
                    boolean bl = false;
                    Object[] objectArray = new TextMateFileNameMatcher[]{new TextMateFileNameMatcher.Name(s), new TextMateFileNameMatcher.Extension(s)};
                    Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List fileNameMatchers = (List)destination$iv$iv;
                PListValue pListValue = plist.getPlistValue("firstLineMatch");
                String firstLinePattern = pListValue != null ? pListValue.getString() : null;
                return new TextMateGrammar(fileNameMatchers, firstLinePattern, (Lazy<Plist>)LazyKt.lazy(() -> readSublimeBundle.1.readGrammars$lambda$1$1(plist)), null, null);
            }

            private static final Plist readGrammars$lambda$1$1(Plist $plist) {
                return $plist;
            }

            private static final boolean readPreferences$lambda$2(String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return StringsKt.endsWith$default((String)name, (String)".tmPreferences", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)".plist", (boolean)false, (int)2, null);
            }

            private static final TextMatePreferences readPreferences$lambda$3(Plist plist) {
                Intrinsics.checkNotNullParameter((Object)plist, (String)"plist");
                return BundleReaderCoreKt.access$readPreferencesFromPlist(plist);
            }

            private static final boolean readSnippets$lambda$4(String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return StringsKt.endsWith$default((String)name, (String)".plist", (boolean)false, (int)2, null);
            }

            private static final TextMateSnippet readSnippets$lambda$5(Plist plist) {
                Intrinsics.checkNotNullParameter((Object)plist, (String)"plist");
                return BundleReaderCoreKt.access$readSnippetFromPlist(plist);
            }
        };
    }

    private static final TextMateSnippet readSnippetFromPlist(Plist plist) {
        String string;
        String it = string = plist.getPlistValue("tabTrigger", "").getString();
        boolean bl = false;
        CharSequence charSequence = it;
        String string2 = !(charSequence == null || charSequence.length() == 0) ? string : null;
        if (string2 == null) {
            return null;
        }
        String key = string2;
        String it2 = it = plist.getPlistValue(Constants.StringKey.CONTENT.getValue(), "").getString();
        boolean bl2 = false;
        CharSequence charSequence2 = it2;
        String string3 = !(charSequence2 == null || charSequence2.length() == 0) ? it : null;
        if (string3 == null) {
            return null;
        }
        String content = string3;
        String it3 = it2 = plist.getPlistValue("name", "").getString();
        boolean bl3 = false;
        CharSequence charSequence3 = it3;
        String string4 = !(charSequence3 == null || charSequence3.length() == 0) ? it2 : null;
        if (string4 == null) {
            string4 = key;
        }
        String name = string4;
        String string5 = plist.getPlistValue("scope", "").getString();
        Intrinsics.checkNotNull((Object)string5);
        String scope = string5;
        String string6 = plist.getPlistValue("description", "").getString();
        Intrinsics.checkNotNull((Object)string6);
        String description = string6;
        String string7 = plist.getPlistValue("uuid", "").getString();
        Intrinsics.checkNotNull((Object)string7);
        String uuid = string7;
        return new TextMateSnippet(key, content, scope, name, description, uuid);
    }

    /*
     * WARNING - void declaration
     */
    private static final TextMatePreferences readPreferencesFromPlist(Plist plist) {
        TextMatePreferences textMatePreferences;
        Object object = plist.getPlistValue("scope");
        if (object != null && (object = ((PListValue)object).getString()) != null) {
            Object scopeName = object;
            boolean bl = false;
            Object object2 = plist.getPlistValue("settings");
            if (object2 != null && (object2 = ((PListValue)object2).getPlist()) != null) {
                Set set;
                Set<TextMateBracePair> set2;
                List list;
                Set set3;
                Iterable it;
                Set set4;
                Object settings = object2;
                boolean bl2 = false;
                Set<TextMateBracePair> highlightingPairs = PreferencesReadUtil.INSTANCE.readPairs(((Plist)settings).getPlistValue("highlightPairs"));
                Set<TextMateBracePair> set5 = PreferencesReadUtil.INSTANCE.readPairs(((Plist)settings).getPlistValue("smartTypingPairs"));
                if (set5 != null) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = set5;
                    boolean $i$f$map = false;
                    set4 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        TextMateBracePair textMateBracePair = (TextMateBracePair)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl3 = false;
                        collection.add(new TextMateAutoClosingPair(((TextMateBracePair)((Object)it)).getLeft(), ((TextMateBracePair)((Object)it)).getRight(), 0));
                    }
                    set3 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                } else {
                    set3 = null;
                }
                Set smartTypingPairs = set3;
                IndentationRules indentationRules = PreferencesReadUtil.INSTANCE.loadIndentationRules((Plist)settings);
                PListValue pListValue = ((Plist)settings).getPlistValue("shellVariables");
                if (pListValue != null) {
                    void $this$mapTo$iv$iv;
                    PListValue variables = pListValue;
                    boolean bl4 = false;
                    Iterable $this$map$iv = variables.getArray();
                    boolean $i$f$map = false;
                    it = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void variable;
                        PListValue pListValue2 = (PListValue)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl5 = false;
                        Plist variablePlist = variable.getPlist();
                        CharSequence charSequence = (CharSequence)scopeName;
                        String string = variablePlist.getPlistValue("name", "").getString();
                        Intrinsics.checkNotNull((Object)string);
                        String string2 = variablePlist.getPlistValue("value", "").getString();
                        Intrinsics.checkNotNull((Object)string2);
                        collection.add(new TextMateShellVariable(charSequence, string, string2));
                    }
                    list = (List)destination$iv$iv;
                } else {
                    list = CollectionsKt.emptyList();
                }
                List variables = list;
                TextMateTextAttributes customHighlightingAttributes = TextMateTextAttributes.Companion.fromPlist((Plist)settings);
                Set<TextMateBracePair> set6 = highlightingPairs;
                if (set6 == null) {
                    set6 = set2 = Constants.Companion.getDEFAULT_HIGHLIGHTING_BRACE_PAIRS();
                }
                if ((set = smartTypingPairs) == null) {
                    set = Constants.Companion.getDEFAULT_SMART_TYPING_BRACE_PAIRS();
                }
                set4 = set;
                textMatePreferences = new TextMatePreferences((String)scopeName, variables, set2, set4, null, null, indentationRules, customHighlightingAttributes, null);
            } else {
                textMatePreferences = null;
            }
        } else {
            textMatePreferences = null;
        }
        return textMatePreferences;
    }

    private static final Sequence<Plist> readPlistInDirectory(TextMateResourceReader $this$readPlistInDirectory, PlistReaderCore plistReader, String relativePath, Function1<? super String, Boolean> filter) {
        return SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)$this$readPlistInDirectory.list(relativePath)), filter), arg_0 -> BundleReaderCoreKt.readPlistInDirectory$lambda$1($this$readPlistInDirectory, relativePath, plistReader, arg_0));
    }

    static /* synthetic */ Sequence readPlistInDirectory$default(TextMateResourceReader textMateResourceReader, PlistReaderCore plistReaderCore, String string, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = BundleReaderCoreKt::readPlistInDirectory$lambda$0;
        }
        return BundleReaderCoreKt.readPlistInDirectory(textMateResourceReader, plistReaderCore, string, (Function1<? super String, Boolean>)function1);
    }

    @Nullable
    public static final Plist readPlist(@NotNull byte[] bytes, @NotNull PlistReaderCore plistReader, @NotNull String debugName) {
        Object object;
        block2: {
            Throwable throwable;
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)plistReader, (String)"plistReader");
            Intrinsics.checkNotNullParameter((Object)debugName, (String)"debugName");
            try {
                boolean bl = false;
                object = Result.constructor-impl((Object)plistReader.read(bytes));
            }
            catch (Throwable throwable2) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
            }
            Throwable throwable3 = Result.exceptionOrNull-impl((Object)object);
            if (throwable3 == null) break block2;
            Throwable e = throwable = throwable3;
            boolean bl = false;
            TextMateBundleReader.Companion.getLogger$intellij_textmate_core().warn(e, (Function0<String>)((Function0)() -> BundleReaderCoreKt.readPlist$lambda$1$0(debugName)));
        }
        return (Plist)(Result.isFailure-impl((Object)object) ? null : object);
    }

    private static final boolean readPlistInDirectory$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final Plist readPlistInDirectory$lambda$1(TextMateResourceReader $this_readPlistInDirectory, String $relativePath, PlistReaderCore $plistReader, String childName) {
        Plist plist;
        Intrinsics.checkNotNullParameter((Object)childName, (String)"childName");
        byte[] byArray = $this_readPlistInDirectory.read($relativePath + "/" + childName);
        if (byArray != null) {
            byte[] bytes = byArray;
            boolean bl = false;
            plist = BundleReaderCoreKt.readPlist(bytes, $plistReader, $relativePath + "/" + childName);
        } else {
            plist = null;
        }
        return plist;
    }

    private static final String readPlist$lambda$1$0(String $debugName) {
        return "Can't load plist from file: " + $debugName;
    }

    public static final /* synthetic */ Sequence access$readPlistInDirectory(TextMateResourceReader $receiver, PlistReaderCore plistReader, String relativePath, Function1 filter) {
        return BundleReaderCoreKt.readPlistInDirectory($receiver, plistReader, relativePath, (Function1<? super String, Boolean>)filter);
    }

    public static final /* synthetic */ TextMatePreferences access$readPreferencesFromPlist(Plist plist) {
        return BundleReaderCoreKt.readPreferencesFromPlist(plist);
    }

    public static final /* synthetic */ TextMateSnippet access$readSnippetFromPlist(Plist plist) {
        return BundleReaderCoreKt.readSnippetFromPlist(plist);
    }
}

