/*
 * Decompiled with CFR 0.152.
 */
package training.learn.course;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.ui.components.panels.NonOpaquePanel;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import training.dsl.HighlightingTriggerMethods;
import training.dsl.LearningBalloonConfig;
import training.dsl.LessonContext;
import training.dsl.LessonUtilKt;
import training.dsl.TaskContext;
import training.dsl.TaskRuntimeContext;
import training.learn.LearnBundle;
import training.learn.course.IftModule;
import training.learn.course.Lesson;
import training.ui.LearningUiHighlightingManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\f\u0010\u0017\u001a\u00020\n*\u00020\tH\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R#\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\b\u000bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR$\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@PX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R%\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\b\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\r\u00a8\u0006\u001f"}, d2={"Ltraining/learn/course/KLesson;", "Ltraining/learn/course/Lesson;", "id", "", "name", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "lessonContent", "Lkotlin/Function1;", "Ltraining/dsl/LessonContext;", "", "Lkotlin/ExtensionFunctionType;", "getLessonContent", "()Lkotlin/jvm/functions/Function1;", "value", "Ltraining/learn/course/IftModule;", "module", "getModule", "()Ltraining/learn/course/IftModule;", "setModule$intellij_featuresTrainer", "(Ltraining/learn/course/IftModule;)V", "fullLessonContent", "getFullLessonContent", "showIndexingTask", "isDumb", "", "project", "Lcom/intellij/openapi/project/Project;", "beforeCaretApplied", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nKLesson.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KLesson.kt\ntraining/learn/course/KLesson\n+ 2 HighlightingTriggerMethods.kt\ntraining/dsl/HighlightingTriggerMethods\n*L\n1#1,56:1\n20#2,2:57\n*S KotlinDebug\n*F\n+ 1 KLesson.kt\ntraining/learn/course/KLesson\n*L\n33#1:57,2\n*E\n"})
public abstract class KLesson
extends Lesson {
    public IftModule module;

    public KLesson(@NonNls @NotNull String id, @Nls @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(id, name);
    }

    @NotNull
    protected abstract Function1<LessonContext, Unit> getLessonContent();

    @Override
    @NotNull
    public IftModule getModule() {
        IftModule iftModule = this.module;
        if (iftModule != null) {
            return iftModule;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"module");
        return null;
    }

    public void setModule$intellij_featuresTrainer(@NotNull IftModule iftModule) {
        Intrinsics.checkNotNullParameter((Object)iftModule, (String)"<set-?>");
        this.module = iftModule;
    }

    @NotNull
    public Function1<LessonContext, Unit> getFullLessonContent() {
        return arg_0 -> KLesson._get_fullLessonContent_$lambda$0(this, arg_0);
    }

    private final void showIndexingTask(LessonContext $this$showIndexingTask) {
        if (this.getProperties().getCanStartInDumbMode()) {
            return;
        }
        $this$showIndexingTask.task((Function1<? super TaskContext, Unit>)((Function1)arg_0 -> KLesson.showIndexingTask$lambda$0(this, arg_0)));
        $this$showIndexingTask.task((Function1<? super TaskContext, Unit>)((Function1)arg_0 -> KLesson.showIndexingTask$lambda$1(this, arg_0)));
        LessonContext.prepareRuntimeTask$default($this$showIndexingTask, null, KLesson::showIndexingTask$lambda$2, 1, null);
    }

    private final boolean isDumb(Project project) {
        return DumbService.Companion.getInstance(project).isDumb();
    }

    public void beforeCaretApplied(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
    }

    private static final Unit _get_fullLessonContent_$lambda$0(KLesson this$0, LessonContext lessonContext) {
        Intrinsics.checkNotNullParameter((Object)lessonContext, (String)"<this>");
        this$0.showIndexingTask(lessonContext);
        this$0.getLessonContent().invoke((Object)lessonContext);
        return Unit.INSTANCE;
    }

    private static final Unit showIndexingTask$lambda$0(KLesson this$0, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        if (!this$0.isDumb($this$task.getProject())) {
            return Unit.INSTANCE;
        }
        HighlightingTriggerMethods this_$iv = TaskContext.triggerAndBorderHighlight$default($this$task, null, 1, null);
        boolean $i$f$component = false;
        this_$iv.explicitComponentDetection(NonOpaquePanel.class, null, (Function2)new Function2<TaskRuntimeContext, NonOpaquePanel, Boolean>(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public final Boolean invoke(TaskRuntimeContext $this$explicitComponentDetection, Component it) {
                void progress;
                Intrinsics.checkNotNullParameter((Object)$this$explicitComponentDetection, (String)"$this$explicitComponentDetection");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                NonOpaquePanel nonOpaquePanel = (NonOpaquePanel)it;
                TaskRuntimeContext $this$showIndexingTask_u24lambda_u240_u240 = $this$explicitComponentDetection;
                boolean bl = false;
                String string = progress.getClass().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                return StringsKt.contains$default((CharSequence)string, (CharSequence)"InlineProgressPanel", (boolean)false, (int)2, null);
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit showIndexingTask$lambda$1(KLesson this$0, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        if (!this$0.isDumb($this$task.getProject())) {
            return Unit.INSTANCE;
        }
        TaskContext.showWarning$default($this$task, LearnBundle.INSTANCE.message("indexing.message", new Object[0]), false, null, arg_0 -> KLesson.showIndexingTask$lambda$1$0(this$0, arg_0), 6, null);
        $this$task.text(LearnBundle.INSTANCE.message("indexing.message", new Object[0]), new LearningBalloonConfig(Balloon.Position.above, 0, false, null, 0, 0, 0, null, null, 504, null));
        LessonUtilKt.waitSmartModeStep($this$task);
        return Unit.INSTANCE;
    }

    private static final boolean showIndexingTask$lambda$1$0(KLesson this$0, TaskRuntimeContext $this$showWarning) {
        Intrinsics.checkNotNullParameter((Object)$this$showWarning, (String)"$this$showWarning");
        return this$0.isDumb($this$showWarning.getProject());
    }

    private static final Unit showIndexingTask$lambda$2(TaskRuntimeContext $this$prepareRuntimeTask) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareRuntimeTask, (String)"$this$prepareRuntimeTask");
        LearningUiHighlightingManager.INSTANCE.clearHighlights();
        return Unit.INSTANCE;
    }
}

