/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ContributedReferenceHost;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralValue;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.lexer.PythonHighlightingLexer;
import com.jetbrains.python.psi.FutureFeature;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFormattedStringElement;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.PyStringElement;
import com.jetbrains.python.psi.PyStringLiteralCoreUtil;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyElementImpl;
import com.jetbrains.python.psi.impl.PyElementPresentation;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStringLiteralExpressionImpl
extends PyElementImpl
implements PyStringLiteralExpression,
PsiLiteralValue,
ContributedReferenceHost {
    @Nullable
    private volatile String myStringValue;
    @Nullable
    private volatile List<TextRange> myValueTextRanges;
    @Nullable
    private volatile List<Pair<TextRange, String>> myDecodedFragments;

    public PyStringLiteralExpressionImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyStringLiteralExpression((PyStringLiteralExpression)this);
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        this.myStringValue = null;
        this.myValueTextRanges = null;
        this.myDecodedFragments = null;
    }

    @NotNull
    public List<TextRange> getStringValueTextRanges() {
        List result = this.myValueTextRanges;
        if (result == null) {
            this.myValueTextRanges = result = super.getStringValueTextRanges();
        }
        List list = result;
        if (list == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public List<Pair<TextRange, String>> getDecodedFragments() {
        List result = this.myDecodedFragments;
        if (result == null) {
            this.myDecodedFragments = result = super.getDecodedFragments();
        }
        List list = result;
        if (list == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(1);
        }
        return list;
    }

    public boolean isInterpolated() {
        return StreamEx.of((Collection)this.getStringElements()).select(PyFormattedStringElement.class).anyMatch(element -> !element.getFragments().isEmpty());
    }

    @NotNull
    public String getStringValue() {
        String result = this.myStringValue;
        if (result == null) {
            this.myStringValue = result = super.getStringValue();
        }
        String string = result;
        if (string == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public Object getValue() {
        return this.getStringValue();
    }

    @Override
    public String toString() {
        return super.toString() + ": " + this.getStringValue();
    }

    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        PyFile file;
        if (context == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(3);
        }
        if (key == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(4);
        }
        PyBuiltinCache builtinCache = PyBuiltinCache.getInstance((PsiElement)((file = PyUtil.as(FileContextUtil.getContextFile((PsiElement)this), PyFile.class)) == null ? this : file));
        LanguageLevel languageLevel = file == null ? LanguageLevel.forElement((PsiElement)this) : file.getLanguageLevel();
        ASTNode firstNode = (ASTNode)ContainerUtil.getFirstItem((List)this.getStringNodes());
        if (firstNode != null) {
            if (firstNode.getElementType() == PyElementTypes.FSTRING_NODE) {
                String prefix = PyStringLiteralCoreUtil.getPrefix((CharSequence)firstNode.getText());
                if (PyStringLiteralUtil.isTemplatePrefix((String)prefix)) {
                    if (languageLevel.isOlderThan(LanguageLevel.PYTHON314)) {
                        return PyBuiltinCache.getInstance((PsiElement)this).getStrType();
                    }
                    PyClassType templateClassType = this.getTemplateClassType();
                    if (templateClassType != null) {
                        return templateClassType;
                    }
                }
                return builtinCache.getUnicodeType(languageLevel);
            }
            if (firstNode.getElementType() == PyTokenTypes.DOCSTRING) {
                return builtinCache.getStrType();
            }
            if (((PyStringElement)firstNode).isBytes()) {
                return builtinCache.getBytesType(languageLevel);
            }
            IElementType type = PythonHighlightingLexer.convertStringType((IElementType)firstNode.getElementType(), (String)firstNode.getText(), (LanguageLevel)languageLevel, (file != null && file.hasImportFromFuture(FutureFeature.UNICODE_LITERALS) ? 1 : 0) != 0);
            if (PyTokenTypes.UNICODE_NODES.contains(type)) {
                return builtinCache.getUnicodeType(languageLevel);
            }
        }
        return builtinCache.getStrType();
    }

    @Nullable
    private PyClassType getTemplateClassType() {
        PyPsiFacade facade = PyPsiFacade.getInstance((Project)this.getProject());
        PyClass templateClass = facade.createClassByQName("string.templatelib.Template", (PsiElement)this.getContainingFile());
        if (templateClass != null) {
            return facade.createClassType(templateClass, false);
        }
        return null;
    }

    public final PsiReference @NotNull [] getReferences() {
        PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this, (PsiReferenceService.Hints)PsiReferenceService.Hints.NO_HINTS);
        if (psiReferenceArray == null) {
            PyStringLiteralExpressionImpl.$$$reportNull$$$0(5);
        }
        return psiReferenceArray;
    }

    public PsiReference getReference() {
        return (PsiReference)ArrayUtil.getFirstElement((Object[])this.getReferences());
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            @NotNull
            public String getPresentableText() {
                String string = PyStringLiteralExpressionImpl.this.getStringValue();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Nullable
            public String getLocationString() {
                String packageForFile = PyElementPresentation.getPackageForFile(PyStringLiteralExpressionImpl.this.getContainingFile());
                return packageForFile != null ? String.format("(%s)", packageForFile) : null;
            }

            @NotNull
            public Icon getIcon(boolean unused) {
                Icon icon = AllIcons.Nodes.Variable;
                if (icon == null) {
                    1.$$$reportNull$$$0(1);
                }
                return icon;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/python/psi/impl/PyStringLiteralExpressionImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPresentableText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIcon";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    public int valueOffsetToTextOffset(int valueOffset) {
        return this.createLiteralTextEscaper().getOffsetInHost(valueOffset, this.getStringValueTextRange());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyStringLiteralExpressionImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringValueTextRanges";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDecodedFragments";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringValue";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyStringLiteralExpressionImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

