/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ast.tree;

import com.google.common.collect.ImmutableList;
import java.util.List;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.opensearch.sql.ast.AbstractNodeVisitor;
import org.opensearch.sql.ast.dsl.AstDSL;
import org.opensearch.sql.ast.tree.Eval;
import org.opensearch.sql.ast.tree.UnresolvedPlan;
import org.opensearch.sql.common.utils.StringUtils;

public class SPath
extends UnresolvedPlan {
    private UnresolvedPlan child;
    private final String inField;
    private final @Nullable String outField;
    private final String path;

    @Override
    public UnresolvedPlan attach(UnresolvedPlan child) {
        this.child = child;
        return this;
    }

    public List<UnresolvedPlan> getChild() {
        return this.child == null ? ImmutableList.of() : ImmutableList.of((Object)this.child);
    }

    @Override
    public <T, C> T accept(AbstractNodeVisitor<T, C> nodeVisitor, C context) {
        return nodeVisitor.visitSpath(this, context);
    }

    public Eval rewriteAsEval() {
        String outField = this.outField;
        String unquotedPath = StringUtils.unquoteText((String)this.path);
        if (outField == null) {
            outField = unquotedPath;
        }
        return AstDSL.eval(this.child, AstDSL.let(AstDSL.field(outField), AstDSL.function("json_extract", AstDSL.field(this.inField), AstDSL.stringLiteral(unquotedPath))));
    }

    @Override
    @Generated
    public String toString() {
        return "SPath(child=" + String.valueOf(this.getChild()) + ", inField=" + this.getInField() + ", outField=" + this.getOutField() + ", path=" + this.getPath() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SPath)) {
            return false;
        }
        SPath other = (SPath)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<UnresolvedPlan> this$child = this.getChild();
        List<UnresolvedPlan> other$child = other.getChild();
        if (this$child == null ? other$child != null : !((Object)this$child).equals(other$child)) {
            return false;
        }
        String this$inField = this.getInField();
        String other$inField = other.getInField();
        if (this$inField == null ? other$inField != null : !this$inField.equals(other$inField)) {
            return false;
        }
        String this$outField = this.getOutField();
        String other$outField = other.getOutField();
        if (this$outField == null ? other$outField != null : !this$outField.equals(other$outField)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        return !(this$path == null ? other$path != null : !this$path.equals(other$path));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SPath;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<UnresolvedPlan> $child = this.getChild();
        result = result * 59 + ($child == null ? 43 : ((Object)$child).hashCode());
        String $inField = this.getInField();
        result = result * 59 + ($inField == null ? 43 : $inField.hashCode());
        String $outField = this.getOutField();
        result = result * 59 + ($outField == null ? 43 : $outField.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        return result;
    }

    @Generated
    public SPath(String inField, @Nullable String outField, String path) {
        this.inField = inField;
        this.outField = outField;
        this.path = path;
    }

    @Generated
    public SPath(UnresolvedPlan child, String inField, @Nullable String outField, String path) {
        this.child = child;
        this.inField = inField;
        this.outField = outField;
        this.path = path;
    }

    @Generated
    public String getInField() {
        return this.inField;
    }

    @Generated
    public @Nullable String getOutField() {
        return this.outField;
    }

    @Generated
    public String getPath() {
        return this.path;
    }
}

