/*
 * Decompiled with CFR 0.152.
 */
package org.passay.spring;

import java.util.Locale;
import org.passay.MessageResolver;
import org.passay.PropertiesMessageResolver;
import org.passay.RuleResultDetail;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.support.MessageSourceAccessor;

public class SpringMessageResolver
implements MessageResolver {
    private final MessageSourceAccessor messageSourceAccessor;
    private final MessageResolver fallbackMessageResolver = new PropertiesMessageResolver();

    public SpringMessageResolver(MessageSource messageSource) {
        this.messageSourceAccessor = new MessageSourceAccessor(messageSource);
    }

    public SpringMessageResolver(MessageSource messageSource, Locale locale) {
        this.messageSourceAccessor = new MessageSourceAccessor(messageSource, locale);
    }

    @Override
    public String resolve(RuleResultDetail detail) {
        try {
            return this.messageSourceAccessor.getMessage(detail.getErrorCode(), detail.getValues());
        }
        catch (NoSuchMessageException e) {
            return this.fallbackMessageResolver.resolve(detail);
        }
    }
}

