/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.referral;

import org.ldaptive.AddOperation;
import org.ldaptive.AddRequest;
import org.ldaptive.Connection;
import org.ldaptive.LdapURL;
import org.ldaptive.Operation;
import org.ldaptive.referral.AbstractReferralHandler;
import org.ldaptive.referral.ReferralConnectionFactory;

public class AddReferralHandler
extends AbstractReferralHandler<AddRequest, Void> {
    public AddReferralHandler() {
        this(10, 0, DEFAULT_CONNECTION_FACTORY);
    }

    public AddReferralHandler(ReferralConnectionFactory factory) {
        this(10, 0, factory);
    }

    public AddReferralHandler(int limit) {
        this(limit, 0, DEFAULT_CONNECTION_FACTORY);
    }

    public AddReferralHandler(int limit, ReferralConnectionFactory factory) {
        this(limit, 0, factory);
    }

    private AddReferralHandler(int limit, int depth, ReferralConnectionFactory factory) {
        super(limit, depth, factory);
    }

    @Override
    protected AddRequest createReferralRequest(AddRequest request, LdapURL url) {
        AddRequest referralRequest = new AddRequest();
        referralRequest.setControls(request.getControls());
        referralRequest.setIntermediateResponseHandlers(request.getIntermediateResponseHandlers());
        referralRequest.setReferralHandler(new AddReferralHandler(this.getReferralLimit(), this.getReferralDepth() + 1, this.getReferralConnectionFactory()));
        if (!url.getEntry().isDefaultBaseDn()) {
            referralRequest.setDn(url.getEntry().getBaseDn());
        } else {
            referralRequest.setDn(request.getDn());
        }
        referralRequest.setLdapAttributes(request.getLdapAttributes());
        return referralRequest;
    }

    @Override
    protected Operation<AddRequest, Void> createReferralOperation(Connection conn) {
        return new AddOperation(conn);
    }
}

