/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import org.bouncycastle.crypto.AuthenticationParameters;
import org.bouncycastle.crypto.MACOperatorFactory;
import org.bouncycastle.crypto.SymmetricKeyGenerator;
import org.bouncycastle.crypto.general.SipHash;
import org.bouncycastle.jcajce.provider.AlgorithmProvider;
import org.bouncycastle.jcajce.provider.BaseKeyGenerator;
import org.bouncycastle.jcajce.provider.BaseMac;
import org.bouncycastle.jcajce.provider.BaseSecretKeyFactory;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import org.bouncycastle.jcajce.provider.KeyGeneratorCreator;
import org.bouncycastle.jcajce.provider.MacParametersCreator;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class ProvSipHash
extends AlgorithmProvider {
    private static final String PREFIX = ProvSipHash.class.getName();

    ProvSipHash() {
    }

    @Override
    public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.SIPHASH-2-4", PREFIX + "$Mac24", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseMac(SipHash.SIPHASH_2_4, (MACOperatorFactory)new SipHash.MACOperatorFactory(), new MacParametersCreator(){

                    public AuthenticationParameters getBaseParameters() {
                        return new SipHash.AuthParameters(SipHash.SIPHASH_2_4);
                    }

                    public AuthenticationParameters createParameters(boolean bl, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
                        return new SipHash.AuthParameters(SipHash.SIPHASH_2_4);
                    }
                });
            }
        }));
        bouncyCastleFipsProvider.addAlias("Alg.Alias.Mac.SIPHASH", "SIPHASH-2-4");
        bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.SIPHASH-4-8", PREFIX + "$Mac48", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseMac(SipHash.SIPHASH_4_8, (MACOperatorFactory)new SipHash.MACOperatorFactory(), new MacParametersCreator(){

                    public AuthenticationParameters getBaseParameters() {
                        return new SipHash.AuthParameters(SipHash.SIPHASH_4_8);
                    }

                    public AuthenticationParameters createParameters(boolean bl, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
                        return new SipHash.AuthParameters(SipHash.SIPHASH_4_8);
                    }
                });
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecretKeyFactory.SIPHASH", PREFIX + "$SIPHASHKFACT", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseSecretKeyFactory("SipHash", SipHash.ALGORITHM, new BaseSecretKeyFactory.Validator(){

                    @Override
                    public byte[] validated(byte[] byArray) throws InvalidKeySpecException {
                        int n = byArray.length * 8;
                        if (n != 128) {
                            throw new InvalidKeySpecException("SipHash key must be of length 128 bits");
                        }
                        return byArray;
                    }
                });
            }
        }));
        bouncyCastleFipsProvider.addAlias("SecretKeyFactory", "SIPHASH", "SIPHASH-2-4", "SIPHASH-4-8");
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyGenerator.SIPHASH", PREFIX + "$KeyGen", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseKeyGenerator(bouncyCastleFipsProvider, "SipHash", 128, true, new KeyGeneratorCreator(){

                    @Override
                    public SymmetricKeyGenerator createInstance(int n, SecureRandom secureRandom) {
                        return new SipHash.KeyGenerator(SipHash.ALGORITHM, secureRandom);
                    }
                });
            }
        }));
        bouncyCastleFipsProvider.addAlias("KeyGenerator", "SIPHASH", "SIPHASH-2-4", "SIPHASH-4-8");
    }
}

