/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.gcs;

import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.cloud.BaseService;
import com.google.cloud.storage.StorageRetryStrategy;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import org.opensearch.ExceptionsHelper;

public class GoogleShouldRetryStorageStrategy
implements StorageRetryStrategy {
    private final DelagateResultRetryAlgorithm<?> idempotentHandler = new DelagateResultRetryAlgorithm(BaseService.EXCEPTION_HANDLER);
    private final DelagateResultRetryAlgorithm<?> nonIdempotentHandler = new DelagateResultRetryAlgorithm(BaseService.EXCEPTION_HANDLER);

    public ResultRetryAlgorithm<?> getIdempotentHandler() {
        return this.idempotentHandler;
    }

    public ResultRetryAlgorithm<?> getNonidempotentHandler() {
        return this.nonIdempotentHandler;
    }

    private static final class DelagateResultRetryAlgorithm<T>
    implements ResultRetryAlgorithm<T> {
        private final ResultRetryAlgorithm<T> resultRetryAlgorithm;

        private DelagateResultRetryAlgorithm(ResultRetryAlgorithm<T> resultRetryAlgorithm) {
            this.resultRetryAlgorithm = resultRetryAlgorithm;
        }

        public TimedAttemptSettings createNextAttempt(Throwable prevThrowable, T prevResponse, TimedAttemptSettings prevSettings) {
            return this.resultRetryAlgorithm.createNextAttempt(prevThrowable, prevResponse, prevSettings);
        }

        public boolean shouldRetry(Throwable prevThrowable, T prevResponse) throws CancellationException {
            if (Objects.nonNull(ExceptionsHelper.unwrap((Throwable)prevThrowable, (Class[])new Class[]{UnknownHostException.class}))) {
                return true;
            }
            if (Objects.nonNull(ExceptionsHelper.unwrap((Throwable)prevThrowable, (Class[])new Class[]{SocketException.class}))) {
                return true;
            }
            return this.resultRetryAlgorithm.shouldRetry(prevThrowable, prevResponse);
        }
    }
}

