/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.alerting.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.commons.alerting.action.IndexMonitorRequest;
import org.opensearch.commons.alerting.model.DocLevelMonitorInput;
import org.opensearch.commons.alerting.model.Input;
import org.opensearch.commons.alerting.model.Monitor;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.rest.RestRequest;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BI\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0010\b\u0002\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fB\u000f\b\u0016\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\b\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020#H\u0002J\u0010\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020\u0003H\u0002J\n\u0010'\u001a\u0004\u0018\u00010(H\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0019\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001c\u00a8\u0006-"}, d2={"Lorg/opensearch/commons/alerting/action/IndexMonitorRequest;", "Lorg/opensearch/action/ActionRequest;", "monitorId", "", "seqNo", "", "primaryTerm", "refreshPolicy", "Lorg/opensearch/action/support/WriteRequest$RefreshPolicy;", "method", "Lorg/opensearch/rest/RestRequest$Method;", "monitor", "Lorg/opensearch/commons/alerting/model/Monitor;", "rbacRoles", "", "(Ljava/lang/String;JJLorg/opensearch/action/support/WriteRequest$RefreshPolicy;Lorg/opensearch/rest/RestRequest$Method;Lorg/opensearch/commons/alerting/model/Monitor;Ljava/util/List;)V", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getMethod", "()Lorg/opensearch/rest/RestRequest$Method;", "getMonitor", "()Lorg/opensearch/commons/alerting/model/Monitor;", "setMonitor", "(Lorg/opensearch/commons/alerting/model/Monitor;)V", "getMonitorId", "()Ljava/lang/String;", "getPrimaryTerm", "()J", "getRbacRoles", "()Ljava/util/List;", "getRefreshPolicy", "()Lorg/opensearch/action/support/WriteRequest$RefreshPolicy;", "getSeqNo", "hasDocLeveMonitorInput", "", "isDocLevelMonitor", "isMonitorOfStandardType", "monitorType", "validate", "Lorg/opensearch/action/ActionRequestValidationException;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "common-utils"})
@SourceDebugExtension(value={"SMAP\nIndexMonitorRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexMonitorRequest.kt\norg/opensearch/commons/alerting/action/IndexMonitorRequest\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,86:1\n11065#2:87\n11400#2,3:88\n*S KotlinDebug\n*F\n+ 1 IndexMonitorRequest.kt\norg/opensearch/commons/alerting/action/IndexMonitorRequest\n*L\n71#1:87\n71#1:88,3\n*E\n"})
public final class IndexMonitorRequest
extends ActionRequest {
    @NotNull
    private final String monitorId;
    private final long seqNo;
    private final long primaryTerm;
    @NotNull
    private final WriteRequest.RefreshPolicy refreshPolicy;
    @NotNull
    private final RestRequest.Method method;
    @NotNull
    private Monitor monitor;
    @Nullable
    private final List<String> rbacRoles;

    @NotNull
    public final String getMonitorId() {
        return this.monitorId;
    }

    public final long getSeqNo() {
        return this.seqNo;
    }

    public final long getPrimaryTerm() {
        return this.primaryTerm;
    }

    @NotNull
    public final WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    @NotNull
    public final RestRequest.Method getMethod() {
        return this.method;
    }

    @NotNull
    public final Monitor getMonitor() {
        return this.monitor;
    }

    public final void setMonitor(@NotNull Monitor monitor) {
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"<set-?>");
        this.monitor = monitor;
    }

    @Nullable
    public final List<String> getRbacRoles() {
        return this.rbacRoles;
    }

    public IndexMonitorRequest(@NotNull String monitorId, long seqNo, long primaryTerm, @NotNull WriteRequest.RefreshPolicy refreshPolicy, @NotNull RestRequest.Method method, @NotNull Monitor monitor, @Nullable List<String> rbacRoles) {
        Intrinsics.checkNotNullParameter((Object)monitorId, (String)"monitorId");
        Intrinsics.checkNotNullParameter((Object)refreshPolicy, (String)"refreshPolicy");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        this.monitorId = monitorId;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.refreshPolicy = refreshPolicy;
        this.method = method;
        this.monitor = monitor;
        this.rbacRoles = rbacRoles;
    }

    public /* synthetic */ IndexMonitorRequest(String string, long l, long l2, WriteRequest.RefreshPolicy refreshPolicy, RestRequest.Method method, Monitor monitor, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            list = null;
        }
        this(string, l, l2, refreshPolicy, method, monitor, list);
    }

    public IndexMonitorRequest(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        long l = sin.readLong();
        long l2 = sin.readLong();
        WriteRequest.RefreshPolicy refreshPolicy = WriteRequest.RefreshPolicy.readFrom((StreamInput)sin);
        Intrinsics.checkNotNullExpressionValue((Object)refreshPolicy, (String)"readFrom(...)");
        Enum enum_ = sin.readEnum(RestRequest.Method.class);
        Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"readEnum(...)");
        RestRequest.Method method = (RestRequest.Method)enum_;
        Monitor monitor = Monitor.Companion.readFrom(sin);
        Intrinsics.checkNotNull((Object)monitor, (String)"null cannot be cast to non-null type org.opensearch.commons.alerting.model.Monitor");
        this(string, l, l2, refreshPolicy, method, monitor, sin.readOptionalStringList());
    }

    @Nullable
    public ActionRequestValidationException validate() {
        if (this.isDocLevelMonitor() && this.hasDocLeveMonitorInput()) {
            Input input = this.monitor.getInputs().get(0);
            Intrinsics.checkNotNull((Object)input, (String)"null cannot be cast to non-null type org.opensearch.commons.alerting.model.DocLevelMonitorInput");
            DocLevelMonitorInput docLevelMonitorInput = (DocLevelMonitorInput)input;
            if (docLevelMonitorInput.getIndices().stream().anyMatch(arg_0 -> IndexMonitorRequest.validate$lambda$0(validate.1.INSTANCE, arg_0))) {
                ActionRequestValidationException actionValidationException = new ActionRequestValidationException();
                actionValidationException.addValidationError("Index patterns are not supported for doc level monitors.");
                return actionValidationException;
            }
        }
        return null;
    }

    private final boolean hasDocLeveMonitorInput() {
        return !((Collection)this.monitor.getInputs()).isEmpty() && this.monitor.getInputs().get(0) instanceof DocLevelMonitorInput;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isDocLevelMonitor() {
        if (StringsKt.isBlank((CharSequence)this.monitor.getMonitorType())) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!this.isMonitorOfStandardType(this.monitor.getMonitorType())) return false;
        String string = this.monitor.getMonitorType();
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string2 = string.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        if (Monitor.MonitorType.valueOf(string2) != Monitor.MonitorType.DOC_LEVEL_MONITOR) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isMonitorOfStandardType(String monitorType) {
        void $this$mapTo$iv$iv;
        Monitor.MonitorType[] $this$map$iv = Monitor.MonitorType.values();
        boolean $i$f$map = false;
        Monitor.MonitorType[] monitorTypeArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_10 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getValue();
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
            String string2 = string.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            collection.add(string2);
        }
        Set standardMonitorTypes = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        String string = monitorType;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string3 = string.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
        return standardMonitorTypes.contains(string3);
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.monitorId);
        out.writeLong(this.seqNo);
        out.writeLong(this.primaryTerm);
        this.refreshPolicy.writeTo(out);
        out.writeEnum((Enum)this.method);
        this.monitor.writeTo(out);
        out.writeOptionalStringCollection((Collection)this.rbacRoles);
    }

    private static final boolean validate$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

