/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.BooleanEndpoint;
import org.opensearch.client.transport.endpoints.BooleanResponse;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class PostVotingConfigExclusionsRequest
extends RequestBase
implements ToCopyableBuilder<Builder, PostVotingConfigExclusionsRequest> {
    @Nonnull
    private final List<String> nodeIds;
    @Nonnull
    private final List<String> nodeNames;
    @Nullable
    private final Time timeout;
    public static final Endpoint<PostVotingConfigExclusionsRequest, BooleanResponse, ErrorResponse> _ENDPOINT = new BooleanEndpoint<PostVotingConfigExclusionsRequest>(request -> "POST", request -> "/_cluster/voting_config_exclusions", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap());

    private PostVotingConfigExclusionsRequest(Builder builder) {
        super(builder);
        this.nodeIds = ApiTypeHelper.unmodifiable(builder.nodeIds);
        this.nodeNames = ApiTypeHelper.unmodifiable(builder.nodeNames);
        this.timeout = builder.timeout;
    }

    public static PostVotingConfigExclusionsRequest of(Function<Builder, ObjectBuilder<PostVotingConfigExclusionsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<String> nodeIds() {
        return this.nodeIds;
    }

    @Nonnull
    public final List<String> nodeNames() {
        return this.nodeNames;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (ApiTypeHelper.isDefined(this.nodeIds)) {
            params.put("node_ids", String.join((CharSequence)",", this.nodeIds));
        }
        if (ApiTypeHelper.isDefined(this.nodeNames)) {
            params.put("node_names", String.join((CharSequence)",", this.nodeNames));
        }
        if (this.timeout != null) {
            params.put("timeout", this.timeout._toJsonString());
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.nodeIds);
        result = 31 * result + Objects.hashCode(this.nodeNames);
        result = 31 * result + Objects.hashCode(this.timeout);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostVotingConfigExclusionsRequest other = (PostVotingConfigExclusionsRequest)o;
        return Objects.equals(this.nodeIds, other.nodeIds) && Objects.equals(this.nodeNames, other.nodeNames) && Objects.equals(this.timeout, other.timeout);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, PostVotingConfigExclusionsRequest> {
        @Nullable
        private List<String> nodeIds;
        @Nullable
        private List<String> nodeNames;
        @Nullable
        private Time timeout;

        public Builder() {
        }

        private Builder(PostVotingConfigExclusionsRequest o) {
            super(o);
            this.nodeIds = Builder._listCopy(o.nodeIds);
            this.nodeNames = Builder._listCopy(o.nodeNames);
            this.timeout = o.timeout;
        }

        private Builder(Builder o) {
            super(o);
            this.nodeIds = Builder._listCopy(o.nodeIds);
            this.nodeNames = Builder._listCopy(o.nodeNames);
            this.timeout = o.timeout;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder nodeIds(List<String> list) {
            this.nodeIds = Builder._listAddAll(this.nodeIds, list);
            return this;
        }

        @Nonnull
        public final Builder nodeIds(String value, String ... values) {
            this.nodeIds = Builder._listAdd(this.nodeIds, value, values);
            return this;
        }

        @Nonnull
        public final Builder nodeNames(List<String> list) {
            this.nodeNames = Builder._listAddAll(this.nodeNames, list);
            return this;
        }

        @Nonnull
        public final Builder nodeNames(String value, String ... values) {
            this.nodeNames = Builder._listAdd(this.nodeNames, value, values);
            return this;
        }

        @Nonnull
        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        @Nonnull
        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        @Nonnull
        public PostVotingConfigExclusionsRequest build() {
            this._checkSingleUse();
            return new PostVotingConfigExclusionsRequest(this);
        }
    }
}

