/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.BucketAggregationBase;
import org.opensearch.client.opensearch._types.aggregations.Buckets;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class FiltersAggregation
extends BucketAggregationBase
implements AggregationVariant,
ToCopyableBuilder<Builder, FiltersAggregation> {
    @Nullable
    private final Buckets<Query> filters;
    @Nullable
    private final Boolean keyed;
    @Nullable
    private final Boolean otherBucket;
    @Nullable
    private final String otherBucketKey;
    public static final JsonpDeserializer<FiltersAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FiltersAggregation::setupFiltersAggregationDeserializer);

    private FiltersAggregation(Builder builder) {
        super(builder);
        this.filters = builder.filters;
        this.keyed = builder.keyed;
        this.otherBucket = builder.otherBucket;
        this.otherBucketKey = builder.otherBucketKey;
    }

    public static FiltersAggregation of(Function<Builder, ObjectBuilder<FiltersAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.Filters;
    }

    @Nullable
    public final Buckets<Query> filters() {
        return this.filters;
    }

    @Nullable
    public final Boolean keyed() {
        return this.keyed;
    }

    @Nullable
    public final Boolean otherBucket() {
        return this.otherBucket;
    }

    @Nullable
    public final String otherBucketKey() {
        return this.otherBucketKey;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.filters != null) {
            generator.writeKey("filters");
            this.filters.serialize(generator, mapper);
        }
        if (this.keyed != null) {
            generator.writeKey("keyed");
            generator.write(this.keyed.booleanValue());
        }
        if (this.otherBucket != null) {
            generator.writeKey("other_bucket");
            generator.write(this.otherBucket.booleanValue());
        }
        if (this.otherBucketKey != null) {
            generator.writeKey("other_bucket_key");
            generator.write(this.otherBucketKey);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupFiltersAggregationDeserializer(ObjectDeserializer<Builder> op) {
        FiltersAggregation.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::filters, Buckets.createBucketsDeserializer(Query._DESERIALIZER), "filters");
        op.add(Builder::keyed, JsonpDeserializer.booleanDeserializer(), "keyed");
        op.add(Builder::otherBucket, JsonpDeserializer.booleanDeserializer(), "other_bucket");
        op.add(Builder::otherBucketKey, JsonpDeserializer.stringDeserializer(), "other_bucket_key");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.filters);
        result = 31 * result + Objects.hashCode(this.keyed);
        result = 31 * result + Objects.hashCode(this.otherBucket);
        result = 31 * result + Objects.hashCode(this.otherBucketKey);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FiltersAggregation other = (FiltersAggregation)o;
        return Objects.equals(this.filters, other.filters) && Objects.equals(this.keyed, other.keyed) && Objects.equals(this.otherBucket, other.otherBucket) && Objects.equals(this.otherBucketKey, other.otherBucketKey);
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, FiltersAggregation> {
        @Nullable
        private Buckets<Query> filters;
        @Nullable
        private Boolean keyed;
        @Nullable
        private Boolean otherBucket;
        @Nullable
        private String otherBucketKey;

        public Builder() {
        }

        private Builder(FiltersAggregation o) {
            super(o);
            this.filters = o.filters;
            this.keyed = o.keyed;
            this.otherBucket = o.otherBucket;
            this.otherBucketKey = o.otherBucketKey;
        }

        private Builder(Builder o) {
            super(o);
            this.filters = o.filters;
            this.keyed = o.keyed;
            this.otherBucket = o.otherBucket;
            this.otherBucketKey = o.otherBucketKey;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder filters(@Nullable Buckets<Query> value) {
            this.filters = value;
            return this;
        }

        @Nonnull
        public final Builder filters(Function<Buckets.Builder<Query>, ObjectBuilder<Buckets<Query>>> fn) {
            return this.filters(fn.apply(new Buckets.Builder()).build());
        }

        @Nonnull
        public final Builder keyed(@Nullable Boolean value) {
            this.keyed = value;
            return this;
        }

        @Nonnull
        public final Builder otherBucket(@Nullable Boolean value) {
            this.otherBucket = value;
            return this;
        }

        @Nonnull
        public final Builder otherBucketKey(@Nullable String value) {
            this.otherBucketKey = value;
            return this;
        }

        @Override
        @Nonnull
        public FiltersAggregation build() {
            this._checkSingleUse();
            return new FiltersAggregation(this);
        }
    }
}

