/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingestion;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.ingestion.ResetSettings;
import org.opensearch.client.opensearch.ingestion.ResumeResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class ResumeRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ResumeRequest> {
    @Nullable
    private final Time clusterManagerTimeout;
    @Nonnull
    private final String index;
    @Nonnull
    private final List<ResetSettings> resetSettings;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<ResumeRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ResumeRequest::setupResumeRequestDeserializer);
    public static final Endpoint<ResumeRequest, ResumeResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<ResumeRequest, ResumeResponse>(request -> "POST", request -> {
        StringBuilder buf = new StringBuilder();
        buf.append("/");
        SimpleEndpoint.pathEncode(request.index, buf);
        buf.append("/ingestion/_resume");
        return buf.toString();
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, ResumeResponse._DESERIALIZER);

    private ResumeRequest(Builder builder) {
        super(builder);
        this.clusterManagerTimeout = builder.clusterManagerTimeout;
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.resetSettings = ApiTypeHelper.unmodifiable(builder.resetSettings);
        this.timeout = builder.timeout;
    }

    public static ResumeRequest of(Function<Builder, ObjectBuilder<ResumeRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time clusterManagerTimeout() {
        return this.clusterManagerTimeout;
    }

    @Nonnull
    public final String index() {
        return this.index;
    }

    @Nonnull
    public final List<ResetSettings> resetSettings() {
        return this.resetSettings;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.resetSettings)) {
            generator.writeKey("reset_settings");
            generator.writeStartArray();
            for (ResetSettings item0 : this.resetSettings) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupResumeRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::resetSettings, JsonpDeserializer.arrayDeserializer(ResetSettings._DESERIALIZER), "reset_settings");
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.clusterManagerTimeout != null) {
            params.put("cluster_manager_timeout", this.clusterManagerTimeout._toJsonString());
        }
        if (this.timeout != null) {
            params.put("timeout", this.timeout._toJsonString());
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.clusterManagerTimeout);
        result = 31 * result + this.index.hashCode();
        result = 31 * result + Objects.hashCode(this.resetSettings);
        result = 31 * result + Objects.hashCode(this.timeout);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResumeRequest other = (ResumeRequest)o;
        return Objects.equals(this.clusterManagerTimeout, other.clusterManagerTimeout) && this.index.equals(other.index) && Objects.equals(this.resetSettings, other.resetSettings) && Objects.equals(this.timeout, other.timeout);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, ResumeRequest> {
        @Nullable
        private Time clusterManagerTimeout;
        private String index;
        @Nullable
        private List<ResetSettings> resetSettings;
        @Nullable
        private Time timeout;

        public Builder() {
        }

        private Builder(ResumeRequest o) {
            super(o);
            this.clusterManagerTimeout = o.clusterManagerTimeout;
            this.index = o.index;
            this.resetSettings = Builder._listCopy(o.resetSettings);
            this.timeout = o.timeout;
        }

        private Builder(Builder o) {
            super(o);
            this.clusterManagerTimeout = o.clusterManagerTimeout;
            this.index = o.index;
            this.resetSettings = Builder._listCopy(o.resetSettings);
            this.timeout = o.timeout;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder clusterManagerTimeout(@Nullable Time value) {
            this.clusterManagerTimeout = value;
            return this;
        }

        @Nonnull
        public final Builder clusterManagerTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.clusterManagerTimeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        @Nonnull
        public final Builder resetSettings(List<ResetSettings> list) {
            this.resetSettings = Builder._listAddAll(this.resetSettings, list);
            return this;
        }

        @Nonnull
        public final Builder resetSettings(ResetSettings value, ResetSettings ... values) {
            this.resetSettings = Builder._listAdd(this.resetSettings, value, values);
            return this;
        }

        @Nonnull
        public final Builder resetSettings(Function<ResetSettings.Builder, ObjectBuilder<ResetSettings>> fn) {
            return this.resetSettings(fn.apply(new ResetSettings.Builder()).build(), new ResetSettings[0]);
        }

        @Nonnull
        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        @Nonnull
        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        @Nonnull
        public ResumeRequest build() {
            this._checkSingleUse();
            return new ResumeRequest(this);
        }
    }
}

