/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockruntime.model.Message;
import software.amazon.awssdk.services.bedrockruntime.model.MessagesCopier;
import software.amazon.awssdk.services.bedrockruntime.model.SystemContentBlock;
import software.amazon.awssdk.services.bedrockruntime.model.SystemContentBlocksCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConverseTokensRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConverseTokensRequest> {
    private static final SdkField<List<Message>> MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("messages").getter(ConverseTokensRequest.getter(ConverseTokensRequest::messages)).setter(ConverseTokensRequest.setter(Builder::messages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Message::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SystemContentBlock>> SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("system").getter(ConverseTokensRequest.getter(ConverseTokensRequest::system)).setter(ConverseTokensRequest.setter(Builder::system)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("system").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SystemContentBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGES_FIELD, SYSTEM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConverseTokensRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Message> messages;
    private final List<SystemContentBlock> system;

    private ConverseTokensRequest(BuilderImpl builder) {
        this.messages = builder.messages;
        this.system = builder.system;
    }

    public final boolean hasMessages() {
        return this.messages != null && !(this.messages instanceof SdkAutoConstructList);
    }

    public final List<Message> messages() {
        return this.messages;
    }

    public final boolean hasSystem() {
        return this.system != null && !(this.system instanceof SdkAutoConstructList);
    }

    public final List<SystemContentBlock> system() {
        return this.system;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMessages() ? this.messages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSystem() ? this.system() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConverseTokensRequest)) {
            return false;
        }
        ConverseTokensRequest other = (ConverseTokensRequest)obj;
        return this.hasMessages() == other.hasMessages() && Objects.equals(this.messages(), other.messages()) && this.hasSystem() == other.hasSystem() && Objects.equals(this.system(), other.system());
    }

    public final String toString() {
        return ToString.builder((String)"ConverseTokensRequest").add("Messages", this.hasMessages() ? this.messages() : null).add("System", this.hasSystem() ? this.system() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "messages": {
                return Optional.ofNullable(clazz.cast(this.messages()));
            }
            case "system": {
                return Optional.ofNullable(clazz.cast(this.system()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("messages", MESSAGES_FIELD);
        map.put("system", SYSTEM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConverseTokensRequest, T> g) {
        return obj -> g.apply((ConverseTokensRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Message> messages = DefaultSdkAutoConstructList.getInstance();
        private List<SystemContentBlock> system = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConverseTokensRequest model) {
            this.messages(model.messages);
            this.system(model.system);
        }

        public final List<Message.Builder> getMessages() {
            List<Message.Builder> result = MessagesCopier.copyToBuilder(this.messages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMessages(Collection<Message.BuilderImpl> messages) {
            this.messages = MessagesCopier.copyFromBuilder(messages);
        }

        @Override
        public final Builder messages(Collection<Message> messages) {
            this.messages = MessagesCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Message ... messages) {
            this.messages(Arrays.asList(messages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Consumer<Message.Builder> ... messages) {
            this.messages(Stream.of(messages).map(c -> (Message)((Message.Builder)Message.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SystemContentBlock.Builder> getSystem() {
            List<SystemContentBlock.Builder> result = SystemContentBlocksCopier.copyToBuilder(this.system);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSystem(Collection<SystemContentBlock.BuilderImpl> system) {
            this.system = SystemContentBlocksCopier.copyFromBuilder(system);
        }

        @Override
        public final Builder system(Collection<SystemContentBlock> system) {
            this.system = SystemContentBlocksCopier.copy(system);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder system(SystemContentBlock ... system) {
            this.system(Arrays.asList(system));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder system(Consumer<SystemContentBlock.Builder> ... system) {
            this.system(Stream.of(system).map(c -> (SystemContentBlock)((SystemContentBlock.Builder)SystemContentBlock.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ConverseTokensRequest build() {
            return new ConverseTokensRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConverseTokensRequest> {
        public Builder messages(Collection<Message> var1);

        public Builder messages(Message ... var1);

        public Builder messages(Consumer<Message.Builder> ... var1);

        public Builder system(Collection<SystemContentBlock> var1);

        public Builder system(SystemContentBlock ... var1);

        public Builder system(Consumer<SystemContentBlock.Builder> ... var1);
    }
}

