"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReportsDashboardsPlugin = void 0;
var _configSchema = require("@osd/config-schema");
var _opensearchReportsPlugin = _interopRequireDefault(require("./backend/opensearch-reports-plugin"));
var _notificationsPlugin = require("./clusters/notificationsPlugin");
var _config = require("./config");
var _routes = _interopRequireDefault(require("./routes"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
//@ts-ignore

class ReportsDashboardsPlugin {
  constructor(context) {
    _defineProperty(this, "logger", void 0);
    _defineProperty(this, "initializerContext", void 0);
    _defineProperty(this, "reportingConfig", void 0);
    this.logger = context.logger.get();
    this.initializerContext = context;
  }
  async setup(core) {
    this.logger.debug('reports-dashboards: Setup');
    core.uiSettings.register({
      'reporting:useOcr': {
        name: 'Reporting use OCR on PDF',
        value: false,
        description: 'Whether to run optical character recognition on PDF reports to make text selectable',
        schema: _configSchema.schema.boolean()
      },
      'reporting:useFOR': {
        name: 'Reporting use ForeignObject rendering',
        value: true,
        description: 'Whether to use ForeignObject rendering when generating reports. If it causes issues, try disabling this option.',
        schema: _configSchema.schema.boolean()
      }
    });
    try {
      const config = await (0, _config.buildConfig)(this.initializerContext, core, this.logger);
      this.reportingConfig = config;
      this.logger.debug('Setup complete');
    } catch (error) {
      this.logger.error(`Error in Reporting setup, reporting may not function properly`);
      this.logger.error(error);
    }
    if (!this.reportingConfig) {
      throw new Error('Reporting Config is not initialized');
    }
    const router = core.http.createRouter();
    // Deprecated API. Switch to the new opensearch client as soon as https://github.com/elastic/kibana/issues/35508 done.
    const opensearchReportsClient = core.opensearch.legacy.createClient('opensearch_reports', {
      plugins: [_opensearchReportsPlugin.default, _notificationsPlugin.NotificationsPlugin]
    });
    const notificationsClient = core.opensearch.legacy.createClient('opensearch_notifications', {
      plugins: [_notificationsPlugin.NotificationsPlugin]
    });

    // Register server side APIs
    (0, _routes.default)(router, this.reportingConfig);

    // put logger into route handler context, so that we don't need to pass through parameters
    core.http.registerRouteHandlerContext(
    //@ts-ignore
    'reporting_plugin', (context, request) => {
      return {
        logger: this.logger,
        opensearchReportsClient,
        notificationsClient
      };
    });
    return {};
  }
  start(core) {
    this.logger.debug('reports-dashboards: Started');
    return {};
  }
  stop() {}
}
exports.ReportsDashboardsPlugin = ReportsDashboardsPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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