"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.REPORTING_NOTIFICATIONS_DASHBOARDS_API = exports.PLUGIN_NAME = exports.PLUGIN_ID = exports.OPENSEARCH_REPORTS_API = exports.NOTIFICATIONS_API = exports.API_PREFIX = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const PLUGIN_NAME = exports.PLUGIN_NAME = 'Reporting';
const PLUGIN_ID = exports.PLUGIN_ID = 'reports-dashboards';
const API_PREFIX = exports.API_PREFIX = '/api/reporting';
const BASE_REPORTS_URI = '/_plugins/_reports';
const OPENSEARCH_REPORTS_API = exports.OPENSEARCH_REPORTS_API = {
  ON_DEMAND_REPORT: `${BASE_REPORTS_URI}/on_demand`,
  REPORT_INSTANCE: `${BASE_REPORTS_URI}/instance`,
  LIST_REPORT_INSTANCES: `${BASE_REPORTS_URI}/instances`,
  REPORT_DEFINITION: `${BASE_REPORTS_URI}/definition`,
  LIST_REPORT_DEFINITIONS: `${BASE_REPORTS_URI}/definitions`
};
const REPORTING_NOTIFICATIONS_API_PREFIX = '/api/reporting_notifications';
const REPORTING_NOTIFICATIONS_DASHBOARDS_API = exports.REPORTING_NOTIFICATIONS_DASHBOARDS_API = Object.freeze({
  GET_CONFIGS: `${REPORTING_NOTIFICATIONS_API_PREFIX}/get_configs`,
  GET_EVENT: `${REPORTING_NOTIFICATIONS_API_PREFIX}/get_event`,
  SEND_TEST_MESSAGE: `${REPORTING_NOTIFICATIONS_API_PREFIX}/test_message`
});
const NOTIFICATIONS_API_BASE_PATH = '/_plugins/_notifications';
const NOTIFICATIONS_API = exports.NOTIFICATIONS_API = Object.freeze({
  CONFIGS: `${NOTIFICATIONS_API_BASE_PATH}/configs`,
  EVENTS: `${NOTIFICATIONS_API_BASE_PATH}/events`,
  TEST_MESSAGE: `${NOTIFICATIONS_API_BASE_PATH}/feature/test`
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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