/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.transport;

import java.io.IOException;
import java.util.List;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.nodes.BaseNodesResponse;
import org.opensearch.cluster.ClusterName;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.timeseries.transport.StatsNodeResponse;

public class StatsNodesResponse
extends BaseNodesResponse<StatsNodeResponse>
implements ToXContentObject {
    private static final String NODES_KEY = "nodes";

    public StatsNodesResponse(StreamInput in) throws IOException {
        super(new ClusterName(in), in.readList(StatsNodeResponse::readStats), in.readList(FailedNodeException::new));
    }

    public StatsNodesResponse(ClusterName clusterName, List<StatsNodeResponse> nodes, List<FailedNodeException> failures) {
        super(clusterName, nodes, failures);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
    }

    public void writeNodesTo(StreamOutput out, List<StatsNodeResponse> nodes) throws IOException {
        out.writeList(nodes);
    }

    public List<StatsNodeResponse> readNodesFrom(StreamInput in) throws IOException {
        return in.readList(StatsNodeResponse::readStats);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NODES_KEY);
        for (StatsNodeResponse adStats : this.getNodes()) {
            DiscoveryNode node = adStats.getNode();
            String nodeId = node.getId();
            builder.startObject(nodeId);
            adStats.toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }
}

