/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.jideoss.ui;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.ui.FlatHTML;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.basic.BasicJideLabelUI;
import java.awt.Color;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class FlatJideLabelUI
extends BasicJideLabelUI {
    private Color disabledForeground;
    private boolean defaults_initialized = false;

    public static ComponentUI createUI(JComponent c) {
        LookAndFeelFactory.installJideExtension();
        return FlatUIUtils.createSharedUI(FlatJideLabelUI.class, FlatJideLabelUI::new);
    }

    protected void installDefaults(JLabel c) {
        super.installDefaults(c);
        if (!this.defaults_initialized) {
            this.disabledForeground = UIManager.getColor("JideLabel.disabledForeground");
            this.defaults_initialized = true;
        }
    }

    protected void uninstallDefaults(JLabel c) {
        super.uninstallDefaults(c);
        this.defaults_initialized = false;
    }

    protected void installComponents(JLabel c) {
        super.installComponents(c);
        FlatHTML.updateRendererCSSFontBaseSize((JComponent)c);
    }

    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        FlatHTML.propertyChange((PropertyChangeEvent)e);
    }

    protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        int mnemIndex = FlatLaf.isShowMnemonics() ? l.getDisplayedMnemonicIndex() : -1;
        g.setColor(l.getForeground());
        FlatUIUtils.drawStringUnderlineCharAt((JComponent)l, (Graphics)g, (String)s, (int)mnemIndex, (int)textX, (int)textY);
    }

    protected void paintDisabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        int mnemIndex = FlatLaf.isShowMnemonics() ? l.getDisplayedMnemonicIndex() : -1;
        g.setColor(this.disabledForeground);
        FlatUIUtils.drawStringUnderlineCharAt((JComponent)l, (Graphics)g, (String)s, (int)mnemIndex, (int)textX, (int)textY);
    }
}

