import Promise from "bluebird";
import { QueueProcessFn } from "./Queue";
/**
 * A Queue Pool is a queue which is backed by a pool of queues which can be serviced
 * concurrently. The number of items which can be processed concurrently is the size
 * of the queue. The QueuePool always operates in a FIFO manner, even when all queues
 * are occupied.
**/
export declare class QueuePool<T> {
    private size;
    private queues;
    private overflow;
    /**
     * Construct a new Queue Pool.
     * This consists of multiple queues. Items will be inserted into
     * the first available free queue. If no queue is free, items will
     * be put in a FIFO overflow queue. You can also use an index when
     * enqueuing to override this behaviour.
    */
    constructor(size: number, fn: QueueProcessFn<T>);
    /**
     * Get number of items waiting to be inserted into a queue.
     */
    get waitingItems(): number;
    /**
     * Add an item to the queue. ID and item are passed directly to the Queue.
     * Index is optional and should be between 0 ~ poolSize-1. It determines
     * which queue to put the item into, which will bypass the overflow queue.
     * Returns: A promise which resolves when the item has been serviced, and
     *          the promise returned by the queue function has resolved.
    */
    enqueue(id: string, item: T, index?: number): Promise<unknown>;
    private onOverflow;
    private freeQueue;
}
