/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.type;

import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.type.TypeNameTranslator;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class ParameterizedTypeInfo
extends TypeInfo {
    final ClassTypeInfo raw;
    final boolean nullable;
    final List<TypeInfo> args;

    public ParameterizedTypeInfo(ClassTypeInfo raw, boolean nullable, List<TypeInfo> args) {
        this.raw = raw;
        this.nullable = nullable;
        this.args = args;
    }

    @Override
    public TypeInfo getErased() {
        return new ParameterizedTypeInfo(this.raw, this.nullable, this.args.stream().map(TypeInfo::getErased).collect(Collectors.toList()));
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public ClassTypeInfo getRaw() {
        return this.raw;
    }

    public List<TypeInfo> getArgs() {
        return this.args;
    }

    public TypeInfo getArg(int index) {
        return this.args.get(index);
    }

    @Override
    public ClassKind getKind() {
        return this.raw.getKind();
    }

    @Override
    public void collectImports(Collection<ClassTypeInfo> imports) {
        this.raw.collectImports(imports);
        this.args.stream().forEach(a -> a.collectImports(imports));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ParameterizedTypeInfo) {
            ParameterizedTypeInfo that = (ParameterizedTypeInfo)obj;
            return this.raw.equals(that.raw) && this.args.equals(that.args);
        }
        return false;
    }

    @Override
    public String format(boolean qualified) {
        StringBuilder buf = new StringBuilder(this.raw.format(qualified)).append('<');
        for (int i = 0; i < this.args.size(); ++i) {
            TypeInfo typeArgument = this.args.get(i);
            if (i > 0) {
                buf.append(',');
            }
            buf.append(typeArgument.format(qualified));
        }
        buf.append('>');
        return buf.toString();
    }

    @Override
    public String translateName(TypeNameTranslator translator) {
        StringBuilder buf = new StringBuilder(this.raw.translateName(translator)).append('<');
        for (int i = 0; i < this.args.size(); ++i) {
            TypeInfo typeArgument = this.args.get(i);
            if (i > 0) {
                buf.append(',');
            }
            buf.append(typeArgument.translateName(translator));
        }
        buf.append('>');
        return buf.toString();
    }

    @Override
    public boolean isParameterized() {
        return true;
    }
}

