/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api;

import io.smallrye.common.classloader.ClassPathUtils;
import io.smallrye.openapi.api.ApiLogging;
import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.OpenApiDocument;
import io.smallrye.openapi.api.OperationHandler;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.OpenApiProcessor;
import io.smallrye.openapi.runtime.OpenApiRuntimeException;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.JsonIO;
import io.smallrye.openapi.runtime.io.OpenAPIDefinitionIO;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import io.smallrye.openapi.runtime.scanner.FilteredIndexView;
import io.smallrye.openapi.runtime.scanner.OpenApiAnnotationScanner;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScanner;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.Type;

public class SmallRyeOpenAPI {
    private final OpenAPI model;
    private final Object jsonModel;
    private final BiFunction<? super Object, Format, String> toString;

    protected SmallRyeOpenAPI(OpenAPI model, Object jsonModel, BiFunction<?, Format, String> toString) {
        this.model = model;
        this.jsonModel = jsonModel;
        this.toString = toString;
    }

    public OpenAPI model() {
        return this.model;
    }

    public String toJSON() {
        return this.toString.apply(this.jsonModel, Format.JSON);
    }

    public String toYAML() {
        return this.toString.apply(this.jsonModel, Format.YAML);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private static final IndexView EMPTY_INDEX = new Indexer().complete();
        private transient BuildContext<?, ?, ?, ?, ?> buildContext;
        private Config config;
        private ClassLoader applicationClassLoader;
        private OpenAPI initialModel;
        private boolean enableModelReader = true;
        private boolean enableStandardStaticFiles = true;
        private Function<String, URL> resourceLocator;
        private Supplier<InputStream> customStaticFile = () -> null;
        private boolean defaultRequiredProperties = true;
        private IndexView index = EMPTY_INDEX;
        private boolean enableAnnotationScan = true;
        private boolean enableUnannotatedPathParameters = false;
        private ClassLoader scannerClassLoader;
        private Predicate<String> scannerFilter = n -> true;
        private OperationHandler operationHandler = OperationHandler.DEFAULT;
        private Function<Collection<ClassInfo>, String> contextRootResolver = apps -> null;
        private UnaryOperator<Type> typeConverter = UnaryOperator.identity();
        private Function<String, Object> jsonParser = null;
        private Function<String, Schema> schemaParser = null;
        private boolean enableStandardFilter = true;
        private Map<String, OASFilter> filters = new LinkedHashMap<String, OASFilter>();

        protected Builder() {
        }

        protected void removeContext() {
            this.buildContext = null;
        }

        protected <V, A extends V, O extends V, AB, OB> BuildContext<V, A, O, AB, OB> getContext() {
            if (this.buildContext == null) {
                this.buildContext = new BuildContext(this);
            }
            return this.buildContext;
        }

        public Builder withConfig(Config config) {
            this.removeContext();
            this.config = Objects.requireNonNull(config);
            return this;
        }

        public Builder withApplicationClassLoader(ClassLoader classLoader) {
            this.removeContext();
            this.applicationClassLoader = Objects.requireNonNull(classLoader);
            return this;
        }

        public Builder withInitialModel(OpenAPI initialModel) {
            this.removeContext();
            this.initialModel = initialModel;
            return this;
        }

        public Builder enableModelReader(boolean enableModelReader) {
            this.removeContext();
            this.enableModelReader = enableModelReader;
            return this;
        }

        public Builder enableStandardStaticFiles(boolean enableStandardStaticFiles) {
            this.removeContext();
            this.enableStandardStaticFiles = enableStandardStaticFiles;
            return this;
        }

        public Builder enableStandardFilter(boolean enableStandardFilter) {
            this.removeContext();
            this.enableStandardFilter = enableStandardFilter;
            return this;
        }

        public Builder defaultRequiredProperties(boolean defaultRequiredProperties) {
            this.removeContext();
            this.defaultRequiredProperties = defaultRequiredProperties;
            return this;
        }

        public Builder withResourceLocator(Function<String, URL> resourceLocator) {
            this.removeContext();
            this.resourceLocator = resourceLocator;
            return this;
        }

        public Builder withCustomStaticFile(Supplier<InputStream> customStaticFile) {
            this.removeContext();
            this.customStaticFile = Objects.requireNonNull(customStaticFile);
            return this;
        }

        public Builder withIndex(IndexView index) {
            this.removeContext();
            this.index = Objects.requireNonNull(index);
            return this;
        }

        public Builder withContextRootResolver(Function<Collection<ClassInfo>, String> contextRootResolver) {
            this.removeContext();
            this.contextRootResolver = Objects.requireNonNull(contextRootResolver);
            return this;
        }

        public Builder withTypeConverter(UnaryOperator<Type> typeConverter) {
            this.removeContext();
            this.typeConverter = Objects.requireNonNull(typeConverter);
            return this;
        }

        public Builder withJsonParser(Function<String, Object> jsonParser) {
            this.removeContext();
            this.jsonParser = jsonParser;
            return this;
        }

        public Builder withSchemaParser(Function<String, Schema> schemaParser) {
            this.removeContext();
            this.schemaParser = schemaParser;
            return this;
        }

        public Builder enableAnnotationScan(boolean enableAnnotationScan) {
            this.removeContext();
            this.enableAnnotationScan = enableAnnotationScan;
            return this;
        }

        public Builder enableUnannotatedPathParameters(boolean enableUnannotatedPathParameters) {
            this.removeContext();
            this.enableUnannotatedPathParameters = enableUnannotatedPathParameters;
            return this;
        }

        public Builder withScannerClassLoader(ClassLoader scannerClassLoader) {
            this.removeContext();
            this.scannerClassLoader = scannerClassLoader;
            return this;
        }

        public Builder withScannerFilter(Predicate<String> scannerFilter) {
            this.removeContext();
            this.scannerFilter = Objects.requireNonNull(scannerFilter);
            return this;
        }

        public Builder withOperationHandler(OperationHandler handler) {
            this.removeContext();
            this.operationHandler = Objects.requireNonNull(handler);
            return this;
        }

        public Builder withFilters(Collection<OASFilter> filters) {
            this.removeContext();
            Objects.requireNonNull(filters);
            this.filters.clear();
            filters.forEach(this::addFilter);
            return this;
        }

        public Builder withFilterNames(Collection<String> filterNames) {
            this.removeContext();
            Objects.requireNonNull(filterNames);
            this.filters.clear();
            filterNames.forEach(this::addFilterName);
            return this;
        }

        public Builder withFilterNames(Collection<String> filterNames, ClassLoader classLoader, IndexView index) {
            this.removeContext();
            Objects.requireNonNull(filterNames);
            this.filters.clear();
            filterNames.forEach(name -> this.addFilter((String)name, classLoader, index));
            return this;
        }

        public Builder addFilter(OASFilter filter) {
            this.removeContext();
            Objects.requireNonNull(filter);
            this.filters.put(filter.getClass().getName(), filter);
            return this;
        }

        public Builder addFilterName(String filterName) {
            this.removeContext();
            Objects.requireNonNull(filterName);
            this.filters.put(filterName, null);
            return this;
        }

        public Builder addFilter(String filterName, ClassLoader classLoader, IndexView index) {
            this.removeContext();
            Objects.requireNonNull(filterName);
            Objects.requireNonNull(classLoader);
            OASFilter filter = OpenApiProcessor.getFilter(filterName, classLoader, index != null ? index : EMPTY_INDEX);
            this.filters.put(filterName, filter);
            return this;
        }

        protected void buildReaderModel(BuildContext<?, ?, ?, ?, ?> ctx) {
            if (this.enableModelReader) {
                ctx.readerModel = OpenApiProcessor.modelFromReader(ctx.buildConfig, ctx.appClassLoader, this.index);
                this.debugModel("reader", ctx.readerModel);
            }
        }

        protected <V, A extends V, O extends V, AB, OB> void buildStaticModel(BuildContext<V, A, O, AB, OB> ctx) {
            InputStream customFile;
            if (this.enableStandardStaticFiles) {
                Function<String, URL> loadFn = Optional.ofNullable(this.resourceLocator).orElse(path -> {
                    StringBuilder loadPath = new StringBuilder((String)path);
                    if (loadPath.charAt(0) == '/') {
                        loadPath.delete(0, 1);
                    }
                    return ctx.appClassLoader.getResource(loadPath.toString());
                });
                for (URL staticFile : OpenApiProcessor.locateStaticFiles(loadFn)) {
                    String source = "static file " + String.valueOf(staticFile);
                    try {
                        Format format = staticFile.toString().endsWith(".json") ? Format.JSON : Format.YAML;
                        ClassPathUtils.consumeStream((URL)staticFile, stream -> this.addStaticModel(ctx, (InputStream)stream, source, format));
                    }
                    catch (IOException e) {
                        String msg = "IOException reading " + source;
                        throw new OpenApiRuntimeException(msg, e);
                    }
                }
            }
            if ((customFile = this.customStaticFile.get()) != null) {
                this.addStaticModel(ctx, customFile, "custom static file", Format.YAML);
            }
        }

        private <V, A extends V, O extends V, AB, OB> void addStaticModel(BuildContext<V, A, O, AB, OB> ctx, InputStream stream, String source, Format fileFormat) {
            try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                Object dom = ctx.modelIO.jsonIO().fromReader(reader, fileFormat);
                OpenAPI fileModel = (OpenAPI)ctx.modelIO.readValue(dom);
                this.debugModel(source, fileModel);
                ctx.staticModel = MergeUtil.merge(fileModel, ctx.staticModel);
            }
            catch (IOException e) {
                String msg = "IOException reading " + source;
                throw new OpenApiRuntimeException(msg, e);
            }
        }

        protected <V, A extends V, O extends V, AB, OB> void buildAnnotationModel(BuildContext<V, A, O, AB, OB> ctx) {
            if (this.enableAnnotationScan && !ctx.buildConfig.scanDisable()) {
                ctx.buildConfig.setAllowNakedPathParameter(this.enableUnannotatedPathParameters);
                AnnotationScannerExtension ext = this.newExtension(ctx.modelIO);
                AnnotationScannerContext scannerContext = new AnnotationScannerContext(ctx.filteredIndex, ctx.appClassLoader, Collections.singletonList(ext), false, ctx.buildConfig, this.operationHandler, OASFactory.createOpenAPI());
                ctx.modelIO.ioContext().scannerContext(scannerContext);
                Supplier supplier = Optional.ofNullable(this.scannerClassLoader).map(AnnotationScannerFactory::new).orElseGet(() -> new AnnotationScannerFactory(ctx.appClassLoader));
                OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(scannerContext, supplier);
                ctx.annotationModel = scanner.scan(this.scannerFilter);
                this.debugModel("annotation", ctx.annotationModel);
            }
        }

        protected void buildStandardFilter(BuildContext<?, ?, ?, ?, ?> ctx) {
            if (this.enableStandardFilter) {
                ctx.standardFilter = OpenApiProcessor.getFilter(ctx.buildConfig, ctx.appClassLoader, (IndexView)ctx.filteredIndex);
            }
        }

        protected void buildPrepare(BuildContext<?, ?, ?, ?, ?> ctx) {
            ctx.doc.set((OpenAPI)null);
        }

        protected <V> SmallRyeOpenAPI buildFinalize(BuildContext<V, ?, ?, ?, ?> ctx) {
            ctx.doc.config(ctx.buildConfig);
            ctx.doc.defaultRequiredProperties(ctx.defaultRequiredProperties);
            ctx.doc.modelFromReader(MergeUtil.merge(ctx.initialModel, ctx.readerModel));
            ctx.doc.modelFromStaticFile(ctx.staticModel);
            ctx.doc.modelFromAnnotations(ctx.annotationModel);
            this.filters.entrySet().stream().map(e -> Optional.ofNullable((OASFilter)e.getValue()).orElseGet(() -> OpenApiProcessor.getFilter((String)e.getKey(), ctx.appClassLoader, (IndexView)ctx.filteredIndex))).forEach(ctx.doc::filter);
            if (ctx.standardFilter != null && !this.filters.containsKey(ctx.standardFilter.getClass().getName())) {
                ctx.doc.filter(ctx.standardFilter);
            }
            ctx.doc.initialize();
            OpenAPI model = ctx.doc.get();
            BiFunction<Object, Format, String> toString = ctx.modelIO.jsonIO()::toString;
            return new SmallRyeOpenAPI(model, ctx.modelIO.write(model).orElse(null), toString);
        }

        public <V, A extends V, O extends V, AB, OB> SmallRyeOpenAPI build() {
            BuildContext<V, A, O, AB, OB> ctx = this.getContext();
            this.buildPrepare(ctx);
            this.buildReaderModel(ctx);
            this.buildStaticModel(ctx);
            this.buildAnnotationModel(ctx);
            this.buildStandardFilter(ctx);
            return this.buildFinalize(ctx);
        }

        private <V, A extends V, O extends V, AB, OB> AnnotationScannerExtension newExtension(final OpenAPIDefinitionIO<V, A, O, AB, OB> modelIO) {
            return new AnnotationScannerExtension(){

                @Override
                public void processScannerApplications(AnnotationScanner scanner, Collection<ClassInfo> applications) {
                    Optional.ofNullable(contextRootResolver.apply(applications)).ifPresent(scanner::setContextRoot);
                }

                @Override
                public Type resolveAsyncType(Type type) {
                    return (Type)typeConverter.apply(type);
                }

                @Override
                public Object parseValue(String value) {
                    return Optional.ofNullable(jsonParser).map(parser -> parser.apply(value)).orElseGet(() -> modelIO.jsonIO().parseValue(value));
                }

                @Override
                public Schema parseSchema(String jsonSchema) {
                    return Optional.ofNullable(schemaParser).map(parser -> (Schema)parser.apply(jsonSchema)).orElseGet(() -> {
                        Object schemaModel = modelIO.jsonIO().fromString(jsonSchema, Format.JSON);
                        return modelIO.schemaIO().readValue(schemaModel);
                    });
                }
            };
        }

        private void debugModel(String source, OpenAPI model) {
            if (model == null) {
                return;
            }
            ApiLogging.logger.addingModel(source);
            this.debugMap("callbacks", source, this.getMap(model, Components::getCallbacks));
            this.debugMap("examples", source, this.getMap(model, Components::getExamples));
            this.debugMap("headers", source, this.getMap(model, Components::getHeaders));
            this.debugMap("links", source, this.getMap(model, Components::getLinks));
            this.debugMap("parameters", source, this.getMap(model, Components::getParameters));
            this.debugMap("request bodies", source, this.getMap(model, Components::getRequestBodies));
            this.debugMap("responses", source, this.getMap(model, Components::getResponses));
            this.debugMap("schemas", source, this.getMap(model, Components::getSchemas));
            this.debugMap("security schemes", source, this.getMap(model, Components::getSecuritySchemes));
            this.debugList("servers", source, Optional.ofNullable(model.getServers()));
            this.debugMap("path items", source, Optional.ofNullable(model.getPaths()).map(Paths::getPathItems));
            this.debugList("security", source, Optional.ofNullable(model.getSecurity()));
            this.debugList("tags", source, Optional.ofNullable(model.getTags()));
            this.debugMap("extensions", source, Optional.ofNullable(model.getExtensions()));
        }

        private Optional<Map<String, ?>> getMap(OpenAPI model, Function<Components, Map<String, ?>> extract) {
            return Optional.ofNullable(model.getComponents()).map(extract);
        }

        private void debugMap(String name, String source, Optional<Map<String, ?>> collection) {
            this.debugModel(name, source, collection.map(Map::size));
        }

        private void debugList(String name, String source, Optional<Collection<?>> collection) {
            this.debugModel(name, source, collection.map(Collection::size));
        }

        private void debugModel(String name, String source, Optional<Integer> collection) {
            ApiLogging.logger.addingModel(name, source, collection.map(Object::toString).orElse("<no>"));
        }

        protected static class BuildContext<V, A extends V, O extends V, AB, OB> {
            ClassLoader appClassLoader;
            OpenApiConfig buildConfig;
            OpenAPIDefinitionIO<V, A, O, AB, OB> modelIO;
            FilteredIndexView filteredIndex;
            OpenAPI initialModel;
            OpenAPI readerModel;
            OpenAPI staticModel;
            OpenAPI annotationModel;
            OASFilter standardFilter;
            boolean defaultRequiredProperties;
            OpenApiDocument doc;

            BuildContext(Builder builder) {
                this.appClassLoader = builder.applicationClassLoader != null ? builder.applicationClassLoader : Thread.currentThread().getContextClassLoader();
                this.buildConfig = OpenApiConfig.fromConfig(Optional.ofNullable(builder.config).orElseGet(() -> ConfigProvider.getConfig((ClassLoader)this.appClassLoader)));
                IOContext io = IOContext.forJson(JsonIO.newInstance(this.buildConfig));
                this.modelIO = new OpenAPIDefinitionIO(io);
                this.filteredIndex = new FilteredIndexView(builder.index, this.buildConfig);
                this.initialModel = builder.initialModel;
                this.defaultRequiredProperties = builder.defaultRequiredProperties;
                this.doc = OpenApiDocument.newInstance();
            }
        }
    }
}

