/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.process;

import io.smallrye.common.process.LineReader;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

final class Gatherer {
    private final int headLines;
    private final int tailLines;
    private final ArrayList<String> head;
    private final ArrayDeque<String> tail;
    private int skipped;

    Gatherer(int headLines, int tailLines) {
        this.headLines = headLines;
        this.head = new ArrayList(headLines);
        this.tailLines = tailLines;
        this.tail = new ArrayDeque(tailLines);
    }

    public void run(LineReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            if (this.head.size() < this.headLines) {
                this.head.add(line);
                continue;
            }
            if (this.tailLines > 0) {
                if (this.tail.size() == this.tailLines) {
                    this.tail.removeFirst();
                    ++this.skipped;
                }
                this.tail.addLast(line);
                continue;
            }
            ++this.skipped;
        }
    }

    public List<String> toList() {
        Optional opt = this.skipped == 0 ? Optional.empty() : Optional.of("\u2026 (skipped " + this.skipped + " line(s)) \u2026");
        return Stream.concat(Stream.concat(this.head.stream(), opt.stream()), this.tail.stream()).toList();
    }
}

