/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.data.Coordinate;

public abstract class Latitude {
    public static Coordinate make(double d) {
        if (Math.abs(d) >= 90.0) {
            return null;
        }
        return new Coordinate(d, d >= 0.0 ? Coordinate.Cardinal.NORTH : Coordinate.Cardinal.SOUTH);
    }

    public static Coordinate make(String string) {
        Coordinate coordinate = Coordinate.parse(string, Coordinate.Cardinal.NORTH, Coordinate.Cardinal.SOUTH);
        if (coordinate == null || Math.abs(coordinate.getDouble()) >= 90.0) {
            return null;
        }
        return coordinate;
    }

    public static Coordinate interpolate(Coordinate coordinate, Coordinate coordinate2, double d) {
        return Coordinate.interpolate(coordinate, coordinate2, d, Coordinate.Cardinal.NORTH, Coordinate.Cardinal.SOUTH);
    }

    public static Coordinate interpolate(Coordinate coordinate, Coordinate coordinate2, int n, int n2) {
        return Latitude.interpolate(coordinate, coordinate2, 1.0 * (double)(n + 1) / (double)(n2 + 1));
    }

    public static boolean hasCardinal(String string) {
        Coordinate.Cardinal cardinal = Coordinate.getCardinal(string, Coordinate.Cardinal.NORTH, Coordinate.Cardinal.SOUTH);
        return cardinal != Coordinate.Cardinal.NO_CARDINAL;
    }
}

