# 1 "otherlibs/dune-glob/src/lexer.mll"
 
open Stdune
open Re

type t =
  | Literal of string
  | Re of Re.t

let no_slash        = diff any (char '/')
let no_slash_no_dot = diff any (set "./")

type stack =
  | Bottom
  | Lbrace of stack
  | Char   of char * stack
  | Re     of Re.t * stack
  | Comma  of stack

let make_group st =
  let rec loop current_re full_res st =
    match st with
    | Bottom       -> failwith "'}' without opening '{'"
    | Re (re, st)  -> loop (re :: current_re) full_res st
    | Char (c, st) -> loop (char c :: current_re) full_res st
    | Comma   st   -> loop [] (seq current_re :: full_res) st
    | Lbrace  st   -> Re (alt (seq current_re :: full_res), st)
  in
  loop [] [] st

let finalize st =
  let rec loop acc st =
    match st with
    | Bottom      -> seq (start :: acc)
    | Re (re, st) -> loop (re       :: acc) st
    | Char (c, st)  -> loop (char c :: acc) st
    | Comma   st  -> loop (char ',' :: acc) st
    | Lbrace  _   -> failwith "unclosed '{'"
  in
  let rec try_str (acc : char list) st =
    match st with
    | Bottom -> Literal (String.of_list acc)
    | Comma st -> try_str (',' :: acc) st
    | Char (c, st) -> try_str (c :: acc) st
    | st ->
      let re =
        let re = [stop] in
        match acc with
        | [] -> re
        | _ :: _ -> str (String.of_list acc) :: re
      in
      Re (loop re st)
  in
  try_str [] st

# 57 "otherlibs/dune-glob/src/lexer.ml"
let __ocaml_lex_tables = {
  Lexing.lex_base =
   "\000\000\001\000\255\255\002\000\245\255\246\255\247\255\248\255\
    \249\255\250\255\251\255\003\000\000\000\255\255\254\255\253\255\
    \003\000\254\255\004\000\005\000\255\255";
  Lexing.lex_backtrk =
   "\002\000\001\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\003\000\010\000\255\255\255\255\255\255\
    \002\000\255\255\255\255\255\255\255\255";
  Lexing.lex_default =
   "\255\255\255\255\000\000\004\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\255\255\014\000\000\000\000\000\000\000\
    \018\000\000\000\018\000\019\000\000\000";
  Lexing.lex_trans =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\019\000\000\000\000\000\000\000\
    \000\000\000\000\001\000\002\000\011\000\015\000\008\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\010\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\006\000\012\000\005\000\
    \017\000\017\000\020\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\009\000\000\000\007\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \013\000\000\000\013\000\255\255\255\255\255\255";
  Lexing.lex_check =
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\016\000\255\255\255\255\255\255\
    \255\255\255\255\000\000\001\000\003\000\011\000\003\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\003\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\003\000\003\000\003\000\
    \016\000\018\000\019\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\003\000\255\255\003\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \012\000\255\255\003\000\016\000\018\000\019\000";
  Lexing.lex_base_code =
   "";
  Lexing.lex_backtrk_code =
   "";
  Lexing.lex_default_code =
   "";
  Lexing.lex_trans_code =
   "";
  Lexing.lex_check_code =
   "";
  Lexing.lex_code =
   "";
}

let rec initial lexbuf =
   __ocaml_lex_initial_rec lexbuf 0
and __ocaml_lex_initial_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 57 "otherlibs/dune-glob/src/lexer.mll"
         ( glob (Re (rep any, Bottom)) lexbuf )
# 160 "otherlibs/dune-glob/src/lexer.ml"

  | 1 ->
# 58 "otherlibs/dune-glob/src/lexer.mll"
         ( glob (Re (seq [no_slash_no_dot; rep no_slash], Bottom)) lexbuf )
# 165 "otherlibs/dune-glob/src/lexer.ml"

  | 2 ->
# 59 "otherlibs/dune-glob/src/lexer.mll"
         ( glob Bottom lexbuf )
# 170 "otherlibs/dune-glob/src/lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_initial_rec lexbuf __ocaml_lex_state

and glob st lexbuf =
   __ocaml_lex_glob_rec st lexbuf 3
and __ocaml_lex_glob_rec st lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 63 "otherlibs/dune-glob/src/lexer.mll"
                  ( finalize st )
# 182 "otherlibs/dune-glob/src/lexer.ml"

  | 1 ->
let
# 64 "otherlibs/dune-glob/src/lexer.mll"
               c
# 188 "otherlibs/dune-glob/src/lexer.ml"
= Lexing.sub_lexeme_char lexbuf (lexbuf.Lexing.lex_start_pos + 1) in
# 64 "otherlibs/dune-glob/src/lexer.mll"
                  ( glob (Char (c                                 , st)) lexbuf )
# 192 "otherlibs/dune-glob/src/lexer.ml"

  | 2 ->
# 65 "otherlibs/dune-glob/src/lexer.mll"
                  ( glob (Re (seq [no_slash_no_dot; rep no_slash] , st)) lexbuf )
# 197 "otherlibs/dune-glob/src/lexer.ml"

  | 3 ->
# 66 "otherlibs/dune-glob/src/lexer.mll"
                  ( glob (Re (rep no_slash                        , st)) lexbuf )
# 202 "otherlibs/dune-glob/src/lexer.ml"

  | 4 ->
# 67 "otherlibs/dune-glob/src/lexer.mll"
                  ( glob (Re (no_slash                            , st)) lexbuf )
# 207 "otherlibs/dune-glob/src/lexer.ml"

  | 5 ->
# 68 "otherlibs/dune-glob/src/lexer.mll"
                  ( glob (Lbrace                                    st ) lexbuf )
# 212 "otherlibs/dune-glob/src/lexer.ml"

  | 6 ->
# 69 "otherlibs/dune-glob/src/lexer.mll"
                  ( glob (Comma                                     st ) lexbuf )
# 217 "otherlibs/dune-glob/src/lexer.ml"

  | 7 ->
# 70 "otherlibs/dune-glob/src/lexer.mll"
                  ( glob (make_group st)                                 lexbuf )
# 222 "otherlibs/dune-glob/src/lexer.ml"

  | 8 ->
# 71 "otherlibs/dune-glob/src/lexer.mll"
                  ( char_set st                                          lexbuf )
# 227 "otherlibs/dune-glob/src/lexer.ml"

  | 9 ->
# 72 "otherlibs/dune-glob/src/lexer.mll"
                  ( failwith "']' without opening '['"                          )
# 232 "otherlibs/dune-glob/src/lexer.ml"

  | 10 ->
let
# 73 "otherlibs/dune-glob/src/lexer.mll"
         c
# 238 "otherlibs/dune-glob/src/lexer.ml"
= Lexing.sub_lexeme_char lexbuf lexbuf.Lexing.lex_start_pos in
# 73 "otherlibs/dune-glob/src/lexer.mll"
                  ( glob (Char (c                                 , st)) lexbuf )
# 242 "otherlibs/dune-glob/src/lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_glob_rec st lexbuf __ocaml_lex_state

and char_set st lexbuf =
   __ocaml_lex_char_set_rec st lexbuf 16
and __ocaml_lex_char_set_rec st lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 76 "otherlibs/dune-glob/src/lexer.mll"
                     s
# 255 "otherlibs/dune-glob/src/lexer.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 1) (lexbuf.Lexing.lex_curr_pos + -1) in
# 76 "otherlibs/dune-glob/src/lexer.mll"
                            ( glob (Re (diff any (set s) , st)) lexbuf )
# 259 "otherlibs/dune-glob/src/lexer.ml"

  | 1 ->
let
# 77 "otherlibs/dune-glob/src/lexer.mll"
                     s
# 265 "otherlibs/dune-glob/src/lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos (lexbuf.Lexing.lex_curr_pos + -1) in
# 77 "otherlibs/dune-glob/src/lexer.mll"
                            ( glob (Re (set s            , st)) lexbuf )
# 269 "otherlibs/dune-glob/src/lexer.ml"

  | 2 ->
# 78 "otherlibs/dune-glob/src/lexer.mll"
                           ( failwith "unclosed character set"        )
# 274 "otherlibs/dune-glob/src/lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_char_set_rec st lexbuf __ocaml_lex_state

;;

# 80 "otherlibs/dune-glob/src/lexer.mll"
 
  let parse_string s =
    let lb = Lexing.from_string s in
    match initial lb with
    | re -> Result.Ok re
    | exception Failure msg ->
      Error (Lexing.lexeme_start lb, msg)

# 290 "otherlibs/dune-glob/src/lexer.ml"
