/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

import java.io.UnsupportedEncodingException;

public class StringUtil {
    private static final char TWO_BYTE_LIMIT = '\u0080';
    private static final int TWO_BYTE_CONSTANT1 = 192;
    private static final int TWO_BYTE_CONSTANT2 = 128;
    private static final int TWO_BYTE_SHIFT1 = 6;
    private static final int TWO_BYTE_MASK1 = 31;
    private static final int TWO_BYTE_MASK2 = 63;
    private static final char THREE_BYTE_LIMIT = '\u0800';
    private static final int THREE_BYTE_CONSTANT1 = 224;
    private static final int THREE_BYTE_CONSTANT2 = 128;
    private static final int THREE_BYTE_CONSTANT3 = 128;
    private static final int THREE_BYTE_SHIFT1 = 12;
    private static final int THREE_BYTE_SHIFT2 = 6;
    private static final int THREE_BYTE_MASK1 = 15;
    private static final int THREE_BYTE_MASK2 = 63;
    private static final int THREE_BYTE_MASK3 = 63;

    public static byte[] getUtf8Bytes(String string) {
        int byteLength = 0;
        int stringLength = string.length();
        for (int stringIndex = 0; stringIndex < stringLength; ++stringIndex) {
            char c = string.charAt(stringIndex);
            byteLength += c == '\u0000' ? 2 : (c < '\u0080' ? 1 : (c < '\u0800' ? 2 : 3));
        }
        byte[] bytes = new byte[byteLength];
        int byteIndex = 0;
        for (int stringIndex = 0; stringIndex < stringLength; ++stringIndex) {
            char c = string.charAt(stringIndex);
            if (c == '\u0000') {
                bytes[byteIndex++] = -64;
                bytes[byteIndex++] = -128;
                continue;
            }
            if (c < '\u0080') {
                bytes[byteIndex++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                bytes[byteIndex++] = (byte)(0xC0 | c >>> 6 & 0x1F);
                bytes[byteIndex++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            bytes[byteIndex++] = (byte)(0xE0 | c >>> 12 & 0xF);
            bytes[byteIndex++] = (byte)(0x80 | c >>> 6 & 0x3F);
            bytes[byteIndex++] = (byte)(0x80 | c & 0x3F);
        }
        return bytes;
    }

    public static String getString(byte[] bytes) throws UnsupportedEncodingException {
        return StringUtil.getStringRepresentation(bytes, bytes.length);
    }

    public static String getStringRepresentation(byte[] bytes, int size) throws UnsupportedEncodingException {
        char[] chars = new char[size];
        int charIndex = 0;
        int byteIndex = 0;
        while (byteIndex < size) {
            int b = bytes[byteIndex++] & 0xFF;
            try {
                chars[charIndex++] = (char)(b < 192 ? b : (b < 224 ? (b & 0x1F) << 6 | bytes[byteIndex++] & 0x3F : (b & 0xF) << 12 | (bytes[byteIndex++] & 0x3F) << 6 | bytes[byteIndex++] & 0x3F));
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new UnsupportedEncodingException("Missing UTF-8 bytes after initial byte [0x" + Integer.toHexString(b) + "] in string [" + new String(chars, 0, charIndex) + "]");
            }
        }
        return new String(chars, 0, charIndex);
    }

    public static String join(String separator, String ... strings) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            sb.append(strings[i]);
            if (i + 1 >= strings.length) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static String toHexString(byte[] bytes) {
        return StringUtil.toHexString(bytes, bytes.length);
    }

    public static String toHexString(byte[] bytes, int size) {
        StringBuffer buffer = new StringBuffer(2 * size);
        for (int index = 0; index < bytes.length; ++index) {
            byte b = bytes[index];
            buffer.append(StringUtil.hexNibble(b >> 4)).append(StringUtil.hexNibble(b));
        }
        return buffer.toString();
    }

    private static char hexNibble(int nibble) {
        return (char)((nibble &= 0xF) < 10 ? 48 + nibble : 97 + nibble - 10);
    }
}

