﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/codepipeline/CodePipeline_EXPORTS.h>
#include <aws/codepipeline/model/ActionExecutionInput.h>
#include <aws/codepipeline/model/ActionExecutionOutput.h>
#include <aws/codepipeline/model/ActionExecutionStatus.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace CodePipeline {
namespace Model {

/**
 * <p>Returns information about an execution of an action, including the action
 * execution ID, and the name, version, and timing of the action. </p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ActionExecutionDetail">AWS
 * API Reference</a></p>
 */
class ActionExecutionDetail {
 public:
  AWS_CODEPIPELINE_API ActionExecutionDetail() = default;
  AWS_CODEPIPELINE_API ActionExecutionDetail(Aws::Utils::Json::JsonView jsonValue);
  AWS_CODEPIPELINE_API ActionExecutionDetail& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CODEPIPELINE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The pipeline execution ID for the action execution.</p>
   */
  inline const Aws::String& GetPipelineExecutionId() const { return m_pipelineExecutionId; }
  inline bool PipelineExecutionIdHasBeenSet() const { return m_pipelineExecutionIdHasBeenSet; }
  template <typename PipelineExecutionIdT = Aws::String>
  void SetPipelineExecutionId(PipelineExecutionIdT&& value) {
    m_pipelineExecutionIdHasBeenSet = true;
    m_pipelineExecutionId = std::forward<PipelineExecutionIdT>(value);
  }
  template <typename PipelineExecutionIdT = Aws::String>
  ActionExecutionDetail& WithPipelineExecutionId(PipelineExecutionIdT&& value) {
    SetPipelineExecutionId(std::forward<PipelineExecutionIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The action execution ID.</p>
   */
  inline const Aws::String& GetActionExecutionId() const { return m_actionExecutionId; }
  inline bool ActionExecutionIdHasBeenSet() const { return m_actionExecutionIdHasBeenSet; }
  template <typename ActionExecutionIdT = Aws::String>
  void SetActionExecutionId(ActionExecutionIdT&& value) {
    m_actionExecutionIdHasBeenSet = true;
    m_actionExecutionId = std::forward<ActionExecutionIdT>(value);
  }
  template <typename ActionExecutionIdT = Aws::String>
  ActionExecutionDetail& WithActionExecutionId(ActionExecutionIdT&& value) {
    SetActionExecutionId(std::forward<ActionExecutionIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The version of the pipeline where the action was run.</p>
   */
  inline int GetPipelineVersion() const { return m_pipelineVersion; }
  inline bool PipelineVersionHasBeenSet() const { return m_pipelineVersionHasBeenSet; }
  inline void SetPipelineVersion(int value) {
    m_pipelineVersionHasBeenSet = true;
    m_pipelineVersion = value;
  }
  inline ActionExecutionDetail& WithPipelineVersion(int value) {
    SetPipelineVersion(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the stage that contains the action.</p>
   */
  inline const Aws::String& GetStageName() const { return m_stageName; }
  inline bool StageNameHasBeenSet() const { return m_stageNameHasBeenSet; }
  template <typename StageNameT = Aws::String>
  void SetStageName(StageNameT&& value) {
    m_stageNameHasBeenSet = true;
    m_stageName = std::forward<StageNameT>(value);
  }
  template <typename StageNameT = Aws::String>
  ActionExecutionDetail& WithStageName(StageNameT&& value) {
    SetStageName(std::forward<StageNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the action.</p>
   */
  inline const Aws::String& GetActionName() const { return m_actionName; }
  inline bool ActionNameHasBeenSet() const { return m_actionNameHasBeenSet; }
  template <typename ActionNameT = Aws::String>
  void SetActionName(ActionNameT&& value) {
    m_actionNameHasBeenSet = true;
    m_actionName = std::forward<ActionNameT>(value);
  }
  template <typename ActionNameT = Aws::String>
  ActionExecutionDetail& WithActionName(ActionNameT&& value) {
    SetActionName(std::forward<ActionNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The start time of the action execution.</p>
   */
  inline const Aws::Utils::DateTime& GetStartTime() const { return m_startTime; }
  inline bool StartTimeHasBeenSet() const { return m_startTimeHasBeenSet; }
  template <typename StartTimeT = Aws::Utils::DateTime>
  void SetStartTime(StartTimeT&& value) {
    m_startTimeHasBeenSet = true;
    m_startTime = std::forward<StartTimeT>(value);
  }
  template <typename StartTimeT = Aws::Utils::DateTime>
  ActionExecutionDetail& WithStartTime(StartTimeT&& value) {
    SetStartTime(std::forward<StartTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The last update time of the action execution.</p>
   */
  inline const Aws::Utils::DateTime& GetLastUpdateTime() const { return m_lastUpdateTime; }
  inline bool LastUpdateTimeHasBeenSet() const { return m_lastUpdateTimeHasBeenSet; }
  template <typename LastUpdateTimeT = Aws::Utils::DateTime>
  void SetLastUpdateTime(LastUpdateTimeT&& value) {
    m_lastUpdateTimeHasBeenSet = true;
    m_lastUpdateTime = std::forward<LastUpdateTimeT>(value);
  }
  template <typename LastUpdateTimeT = Aws::Utils::DateTime>
  ActionExecutionDetail& WithLastUpdateTime(LastUpdateTimeT&& value) {
    SetLastUpdateTime(std::forward<LastUpdateTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the user who changed the pipeline execution details.</p>
   */
  inline const Aws::String& GetUpdatedBy() const { return m_updatedBy; }
  inline bool UpdatedByHasBeenSet() const { return m_updatedByHasBeenSet; }
  template <typename UpdatedByT = Aws::String>
  void SetUpdatedBy(UpdatedByT&& value) {
    m_updatedByHasBeenSet = true;
    m_updatedBy = std::forward<UpdatedByT>(value);
  }
  template <typename UpdatedByT = Aws::String>
  ActionExecutionDetail& WithUpdatedBy(UpdatedByT&& value) {
    SetUpdatedBy(std::forward<UpdatedByT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The status of the action execution. Status categories are
   * <code>InProgress</code>, <code>Succeeded</code>, and <code>Failed</code>.</p>
   */
  inline ActionExecutionStatus GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  inline void SetStatus(ActionExecutionStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline ActionExecutionDetail& WithStatus(ActionExecutionStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Input details for the action execution, such as role ARN, Region, and input
   * artifacts.</p>
   */
  inline const ActionExecutionInput& GetInput() const { return m_input; }
  inline bool InputHasBeenSet() const { return m_inputHasBeenSet; }
  template <typename InputT = ActionExecutionInput>
  void SetInput(InputT&& value) {
    m_inputHasBeenSet = true;
    m_input = std::forward<InputT>(value);
  }
  template <typename InputT = ActionExecutionInput>
  ActionExecutionDetail& WithInput(InputT&& value) {
    SetInput(std::forward<InputT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Output details for the action execution, such as the action execution
   * result.</p>
   */
  inline const ActionExecutionOutput& GetOutput() const { return m_output; }
  inline bool OutputHasBeenSet() const { return m_outputHasBeenSet; }
  template <typename OutputT = ActionExecutionOutput>
  void SetOutput(OutputT&& value) {
    m_outputHasBeenSet = true;
    m_output = std::forward<OutputT>(value);
  }
  template <typename OutputT = ActionExecutionOutput>
  ActionExecutionDetail& WithOutput(OutputT&& value) {
    SetOutput(std::forward<OutputT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_pipelineExecutionId;

  Aws::String m_actionExecutionId;

  int m_pipelineVersion{0};

  Aws::String m_stageName;

  Aws::String m_actionName;

  Aws::Utils::DateTime m_startTime{};

  Aws::Utils::DateTime m_lastUpdateTime{};

  Aws::String m_updatedBy;

  ActionExecutionStatus m_status{ActionExecutionStatus::NOT_SET};

  ActionExecutionInput m_input;

  ActionExecutionOutput m_output;
  bool m_pipelineExecutionIdHasBeenSet = false;
  bool m_actionExecutionIdHasBeenSet = false;
  bool m_pipelineVersionHasBeenSet = false;
  bool m_stageNameHasBeenSet = false;
  bool m_actionNameHasBeenSet = false;
  bool m_startTimeHasBeenSet = false;
  bool m_lastUpdateTimeHasBeenSet = false;
  bool m_updatedByHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_inputHasBeenSet = false;
  bool m_outputHasBeenSet = false;
};

}  // namespace Model
}  // namespace CodePipeline
}  // namespace Aws
