/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.FuncDecl;
import com.microsoft.z3.Lambda;
import com.microsoft.z3.Native;
import com.microsoft.z3.Quantifier;
import com.microsoft.z3.Sort;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.Z3Object;
import com.microsoft.z3.Z3ReferenceQueue;
import com.microsoft.z3.enumerations.Z3_ast_kind;
import java.lang.ref.ReferenceQueue;

public class AST
extends Z3Object
implements Comparable<AST> {
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AST)) {
            return false;
        }
        AST aST = (AST)object;
        return this.getContext().nCtx() == aST.getContext().nCtx() && Native.isEqAst(this.getContext().nCtx(), this.getNativeObject(), aST.getNativeObject());
    }

    @Override
    public int compareTo(AST aST) {
        if (aST == null) {
            return 1;
        }
        return Integer.compare(this.getId(), aST.getId());
    }

    public int hashCode() {
        return Native.getAstHash(this.getContext().nCtx(), this.getNativeObject());
    }

    public int getId() {
        return Native.getAstId(this.getContext().nCtx(), this.getNativeObject());
    }

    public AST translate(Context context) {
        if (this.getContext() == context) {
            return this;
        }
        return AST.create(context, Native.translate(this.getContext().nCtx(), this.getNativeObject(), context.nCtx()));
    }

    public Z3_ast_kind getASTKind() {
        return Z3_ast_kind.fromInt(Native.getAstKind(this.getContext().nCtx(), this.getNativeObject()));
    }

    public boolean isExpr() {
        switch (this.getASTKind()) {
            case Z3_APP_AST: 
            case Z3_NUMERAL_AST: 
            case Z3_QUANTIFIER_AST: 
            case Z3_VAR_AST: {
                return true;
            }
        }
        return false;
    }

    public boolean isApp() {
        return this.getASTKind() == Z3_ast_kind.Z3_APP_AST;
    }

    public boolean isVar() {
        return this.getASTKind() == Z3_ast_kind.Z3_VAR_AST;
    }

    public boolean isQuantifier() {
        return this.getASTKind() == Z3_ast_kind.Z3_QUANTIFIER_AST;
    }

    public boolean isSort() {
        return this.getASTKind() == Z3_ast_kind.Z3_SORT_AST;
    }

    public boolean isFuncDecl() {
        return this.getASTKind() == Z3_ast_kind.Z3_FUNC_DECL_AST;
    }

    public String toString() {
        return Native.astToString(this.getContext().nCtx(), this.getNativeObject());
    }

    public String getSExpr() {
        return Native.astToString(this.getContext().nCtx(), this.getNativeObject());
    }

    AST(Context context, long l) {
        super(context, l);
    }

    @Override
    void incRef() {
        Native.incRef(this.getContext().nCtx(), this.getNativeObject());
    }

    @Override
    void addToReferenceQueue() {
        this.getContext().getReferenceQueue().storeReference(this, ASTRef::new);
    }

    static AST create(Context context, long l) {
        switch (Z3_ast_kind.fromInt(Native.getAstKind(context.nCtx(), l))) {
            case Z3_FUNC_DECL_AST: {
                return new FuncDecl(context, l);
            }
            case Z3_QUANTIFIER_AST: {
                boolean bl;
                boolean bl2 = bl = !Native.isQuantifierExists(context.nCtx(), l) && !Native.isQuantifierForall(context.nCtx(), l);
                if (bl) {
                    return new Lambda(context, l);
                }
                return new Quantifier(context, l);
            }
            case Z3_SORT_AST: {
                return Sort.create(context, l);
            }
            case Z3_APP_AST: 
            case Z3_NUMERAL_AST: 
            case Z3_VAR_AST: {
                return Expr.create(context, l);
            }
        }
        throw new Z3Exception("Unknown AST kind");
    }

    private static class ASTRef
    extends Z3ReferenceQueue.Reference<AST> {
        private ASTRef(AST aST, ReferenceQueue<Z3Object> referenceQueue) {
            super(aST, referenceQueue);
        }

        @Override
        void decRef(Context context, long l) {
            Native.decRef(context.nCtx(), l);
        }
    }
}

