/*
 * Decompiled with CFR 0.152.
 */
package xtpipes;

import java.io.File;
import java.io.PrintWriter;
import java.util.HashMap;

public class FileInfo {
    static String[] classPaths = null;
    static String[] scriptPaths = null;
    static HashMap<String, String> registry = new HashMap();
    static String slash = System.getProperty("file.separator");
    static String ii_scriptDir;
    static PrintWriter log;
    static boolean trace;

    public FileInfo(PrintWriter printWriter, String string, boolean bl) {
        log = printWriter;
        ii_scriptDir = string;
        trace = bl;
        classPaths = FileInfo.getPaths(System.getProperty("java.class.path"));
        if (string != null) {
            scriptPaths = FileInfo.getPaths(string);
        }
    }

    public static String searchFile(String string) {
        String string2 = (ii_scriptDir == null ? "" : ii_scriptDir) + "!" + string;
        String string3 = registry.get(string2);
        if (string3 == null) {
            for (int i = 0; i < 2; ++i) {
                if (trace) {
                    log.println("Searching: " + string);
                }
                if (new File(string).exists()) {
                    string3 = string.indexOf(slash) == -1 ? System.getProperty("user.dir") + slash + string : string;
                } else {
                    String string4;
                    int n;
                    if (ii_scriptDir != null) {
                        n = scriptPaths.length;
                        while (n > 0) {
                            --n;
                            if (trace) {
                                log.println("Searching: " + string + ", recursively in directory: " + scriptPaths[n]);
                            }
                            if ((string3 = FileInfo.searchDirectory(new File(scriptPaths[n]), string)) == null) continue;
                        }
                        if (new File(string4 = ii_scriptDir + string).exists()) {
                            string3 = string4;
                        }
                    }
                    if (string3 == null) {
                        n = classPaths.length;
                        string4 = "xtpipes" + slash + "lib" + slash + string;
                        while (n > 0) {
                            String string5 = classPaths[--n] + string4;
                            if (trace) {
                                log.println("Searching: " + string5);
                            }
                            if (!new File(string5).exists()) continue;
                            string3 = string5;
                            break;
                        }
                    }
                }
                if (string3 != null) break;
                string = new File(string).getName();
            }
            if (string3 != null) {
                string3 = FileInfo.cleanPath(string3);
                registry.put(string2, string3);
            }
        }
        if (trace) {
            if (string3 == null) {
                log.println("Directory paths from xtpipes command line option -i: " + ii_scriptDir);
            } else {
                log.println("Found: " + string3 + "\n");
            }
            log.flush();
        }
        return string3;
    }

    static String[] getPaths(String string) {
        String[] stringArray = null;
        stringArray = string.split(System.getProperty("path.separator"));
        int n = stringArray.length;
        while (n > 0) {
            stringArray[--n] = FileInfo.cleanPath(stringArray[n]);
            int n2 = stringArray[n].length();
            if (n2 > 1 && stringArray[n].lastIndexOf(slash + ".") == n2 - 1) {
                stringArray[n] = stringArray[n].substring(0, n2 - 1);
                continue;
            }
            if (n2 <= 0 || n2 - 1 == stringArray[n].lastIndexOf(slash)) continue;
            int n3 = n;
            stringArray[n3] = stringArray[n3] + slash;
        }
        return stringArray;
    }

    public static String cleanPath(String string) {
        int n;
        String string2;
        int n2;
        String string3 = System.getProperty("file.separator");
        String string4 = System.getProperty("user.dir");
        if (string.length() > 0 && string.charAt(0) == '~' && (string.length() == 1 || string.charAt(1) != '~')) {
            string = System.getProperty("user.home") + string.substring(1);
        }
        if (string.startsWith("..")) {
            string = string4.substring(0, Math.max(0, Math.max(string4.lastIndexOf("/"), string4.lastIndexOf("\\")))) + string.substring(2);
        }
        if (string.startsWith(".")) {
            string = string4 + string3 + string.substring(1);
        }
        while ((n2 = string.indexOf("/..")) != -1 || (n2 = string.indexOf("\\..")) != -1) {
            string2 = string.substring(0, n2);
            n = Math.max(string2.lastIndexOf("/"), string2.lastIndexOf("\\"));
            string = string.substring(0, n) + string.substring(n2 + 3);
        }
        while ((n2 = string.indexOf("/.")) != -1 || (n2 = string.indexOf("\\.")) != -1) {
            string2 = string.substring(0, n2);
            n = Math.max(string2.indexOf("/"), string2.indexOf("\\"));
            string = string.substring(0, n) + string.substring(n2 + 2);
        }
        return string;
    }

    static String searchDirectory(File file, String string) {
        String string2 = null;
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length && (string2 = FileInfo.searchDirectory(new File(file, stringArray[i]), string)) == null; ++i) {
            }
        } else {
            String string3 = file.toString();
            if (string3.equals(string) || string3.endsWith(slash + string)) {
                string2 = string3;
            }
        }
        return string2;
    }
}

