/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.web;

import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSNonProxyObject;
import java.util.Arrays;

public final class JSTextDecoderObject
extends JSNonProxyObject {
    private final TruffleString encoding;
    private final TruffleString.Encoding truffleStringEncoding;
    private final boolean fatal;
    private final boolean ignoreBOM;
    private boolean bomSeen;
    private byte[] pendingBytes;

    protected JSTextDecoderObject(Shape shape, JSDynamicObject proto, TruffleString encoding, TruffleString.Encoding truffleStringEncoding, boolean fatal, boolean ignoreBOM) {
        super(shape, proto);
        this.fatal = fatal;
        this.ignoreBOM = ignoreBOM;
        this.encoding = encoding;
        this.truffleStringEncoding = truffleStringEncoding;
    }

    public TruffleString getEncoding() {
        return this.encoding;
    }

    public TruffleString.Encoding getTruffleStringEncoding() {
        return this.truffleStringEncoding;
    }

    public boolean isFatal() {
        return this.fatal;
    }

    public boolean isIgnoreBOM() {
        return this.ignoreBOM;
    }

    public void setBomSeen() {
        this.bomSeen = true;
    }

    public boolean isBomSeen() {
        return this.bomSeen;
    }

    public byte[] getPendingBytes() {
        return this.pendingBytes;
    }

    public void setPendingBytes(byte[] pendingBytes, int start, int end) {
        if (start == end) {
            this.clearPendingBytes();
        } else {
            this.pendingBytes = Arrays.copyOfRange(pendingBytes, start, end);
        }
    }

    private void clearPendingBytes() {
        this.pendingBytes = null;
    }

    public void endDecode(boolean stream, boolean onError) {
        if (!stream) {
            this.bomSeen = false;
        }
        if (!stream || onError) {
            this.clearPendingBytes();
        }
    }
}

