/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jaybird.parser;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.firebirdsql.jaybird.parser.AbstractTokenVisitor;
import org.firebirdsql.jaybird.parser.CharSequenceComparison;
import org.firebirdsql.jaybird.parser.ColonToken;
import org.firebirdsql.jaybird.parser.CommaToken;
import org.firebirdsql.jaybird.parser.CurlyBraceClose;
import org.firebirdsql.jaybird.parser.CurlyBraceOpen;
import org.firebirdsql.jaybird.parser.GenericToken;
import org.firebirdsql.jaybird.parser.OpenToken;
import org.firebirdsql.jaybird.parser.OperatorToken;
import org.firebirdsql.jaybird.parser.ParenthesisClose;
import org.firebirdsql.jaybird.parser.ParenthesisOpen;
import org.firebirdsql.jaybird.parser.PeriodToken;
import org.firebirdsql.jaybird.parser.ReservedToken;
import org.firebirdsql.jaybird.parser.SquareBracketClose;
import org.firebirdsql.jaybird.parser.SquareBracketOpen;
import org.firebirdsql.jaybird.parser.Token;

class ReturningClauseDetector
extends AbstractTokenVisitor {
    private static final Token UNDEFINED_TOKEN = new Token(){

        @Override
        public String text() {
            return "";
        }

        @Override
        public int position() {
            return -1;
        }

        @Override
        public int length() {
            return 0;
        }
    };
    private static final Set<CharSequence> NOT_IN_RETURNING_TOKEN_TEXT;
    private static final Set<CharSequence> NOT_IMMEDIATELY_BEFORE_RETURNING_TOKEN_TEXT;
    private static final Set<CharSequence> NOT_IMMEDIATELY_AFTER_RETURNING_TOKEN_TEXT;
    private final ArrayDeque<ParserState> preservedState = new ArrayDeque();
    private ParserState parserState = ParserState.FIND_RETURNING;
    private Token previousToken = UNDEFINED_TOKEN;
    private int returningClauseTokenCount;
    private Boolean returningClauseFound;

    ReturningClauseDetector() {
    }

    @Override
    public void visitToken(Token token) {
        this.parserState = this.parserState.next(token, this);
    }

    @Override
    public void complete() {
        this.returningClauseFound = this.hasReturningClauseTokens();
    }

    public boolean returningClauseDetected() {
        return this.returningClauseFound == Boolean.TRUE;
    }

    private void pushParserState(ParserState parserState) {
        this.preservedState.addFirst(parserState);
    }

    private ParserState popParserState() {
        return this.preservedState.removeFirst();
    }

    private boolean cannotOccurInReturning(Token token) {
        return !this.hasReturningClauseTokens() && this.cannotOccurAsFirstReturningToken(token) || token instanceof ReservedToken && NOT_IN_RETURNING_TOKEN_TEXT.contains(token.textAsCharSequence());
    }

    private boolean cannotOccurAsFirstReturningToken(Token token) {
        OperatorToken operatorToken;
        return token instanceof OperatorToken && !ReturningClauseDetector.isPossibleUnaryOperator(operatorToken = (OperatorToken)token) && !operatorToken.equalsIgnoreCase("*") || NOT_IMMEDIATELY_AFTER_RETURNING_TOKEN_TEXT.contains(token.textAsCharSequence());
    }

    private boolean isReturningClausePossible() {
        if (this.previousToken instanceof OperatorToken || this.previousToken instanceof ColonToken || this.previousToken instanceof PeriodToken || this.previousToken instanceof CommaToken || this.previousToken instanceof OpenToken) {
            return false;
        }
        return !NOT_IMMEDIATELY_BEFORE_RETURNING_TOKEN_TEXT.contains(this.previousToken.textAsCharSequence());
    }

    private static boolean isPossibleUnaryOperator(OperatorToken token) {
        return token.equalsIgnoreCase("+") || token.equalsIgnoreCase("-") || token.equalsIgnoreCase("NOT");
    }

    private void incrementReturningClauseTokenCount() {
        ++this.returningClauseTokenCount;
    }

    private boolean hasReturningClauseTokens() {
        return this.returningClauseTokenCount > 0;
    }

    private void resetReturningClauseTokens() {
        this.returningClauseTokenCount = 0;
    }

    static {
        TreeSet<CharSequence> notInReturningTokenText = new TreeSet<CharSequence>(CharSequenceComparison.caseInsensitiveComparator());
        notInReturningTokenText.addAll(Arrays.asList("VALUES", "SELECT", "INSERT", "UPDATE", "DELETE", "MERGE", "WHERE", "PLAN", "ORDER", "ROWS", "SET"));
        NOT_IN_RETURNING_TOKEN_TEXT = Collections.unmodifiableSet(notInReturningTokenText);
        TreeSet<CharSequence> notImmediatelyBeforeReturningTokenText = new TreeSet<CharSequence>((SortedSet<CharSequence>)notInReturningTokenText);
        notImmediatelyBeforeReturningTokenText.remove("VALUES");
        notImmediatelyBeforeReturningTokenText.addAll(Arrays.asList("WITH", "CONTAINING", "TO", "FROM", "BETWEEN"));
        NOT_IMMEDIATELY_BEFORE_RETURNING_TOKEN_TEXT = Collections.unmodifiableSet(notImmediatelyBeforeReturningTokenText);
        TreeSet<CharSequence> notImmediatelyAfterReturningTokenText = new TreeSet<CharSequence>(CharSequenceComparison.caseInsensitiveComparator());
        notImmediatelyAfterReturningTokenText.addAll(Arrays.asList("FROM", "AS", "TO"));
        NOT_IMMEDIATELY_AFTER_RETURNING_TOKEN_TEXT = Collections.unmodifiableSet(notImmediatelyAfterReturningTokenText);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum ParserState {
        FIND_RETURNING{

            @Override
            ParserState next0(Token token, ReturningClauseDetector detector) {
                if (token instanceof GenericToken && token.equalsIgnoreCase("returning") && detector.isReturningClausePossible()) {
                    return IN_RETURNING;
                }
                if (token instanceof OpenToken) {
                    OpenToken openToken = (OpenToken)token;
                    return this.nextForOpenToken(openToken, detector);
                }
                return this;
            }
        }
        ,
        IN_RETURNING{

            @Override
            ParserState next0(Token token, ReturningClauseDetector detector) {
                if (token instanceof OpenToken) {
                    OpenToken openToken = (OpenToken)token;
                    return this.nextForOpenToken(openToken, detector);
                }
                if (detector.cannotOccurInReturning(token)) {
                    detector.resetReturningClauseTokens();
                    return FIND_RETURNING;
                }
                detector.incrementReturningClauseTokenCount();
                return this;
            }
        }
        ,
        NESTED_PARENTHESIS{

            @Override
            ParserState next0(Token token, ReturningClauseDetector detector) {
                if (token instanceof OpenToken) {
                    OpenToken openToken = (OpenToken)token;
                    return this.nextForOpenToken(openToken, detector);
                }
                if (token instanceof ParenthesisClose) {
                    return this.nextForCloseToken(detector);
                }
                return this;
            }
        }
        ,
        NESTED_CURLY_BRACE{

            @Override
            ParserState next0(Token token, ReturningClauseDetector detector) {
                if (token instanceof OpenToken) {
                    OpenToken openToken = (OpenToken)token;
                    return this.nextForOpenToken(openToken, detector);
                }
                if (token instanceof CurlyBraceClose) {
                    return this.nextForCloseToken(detector);
                }
                return this;
            }
        }
        ,
        NESTED_SQUARE_BRACKET{

            @Override
            ParserState next0(Token token, ReturningClauseDetector detector) {
                if (token instanceof OpenToken) {
                    OpenToken openToken = (OpenToken)token;
                    return this.nextForOpenToken(openToken, detector);
                }
                if (token instanceof SquareBracketClose) {
                    return this.nextForCloseToken(detector);
                }
                return this;
            }
        };


        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final ParserState next(Token token, ReturningClauseDetector detector) {
            if (token.isWhitespaceOrComment()) {
                return this;
            }
            try {
                ParserState parserState = this.next0(token, detector);
                return parserState;
            }
            finally {
                detector.previousToken = token;
            }
        }

        abstract ParserState next0(Token var1, ReturningClauseDetector var2);

        final ParserState nextForOpenToken(OpenToken token, ReturningClauseDetector detector) {
            detector.pushParserState(this);
            if (token instanceof ParenthesisOpen) {
                return NESTED_PARENTHESIS;
            }
            if (token instanceof CurlyBraceOpen) {
                return NESTED_CURLY_BRACE;
            }
            if (token instanceof SquareBracketOpen) {
                return NESTED_SQUARE_BRACKET;
            }
            if (detector.popParserState() == IN_RETURNING) {
                detector.incrementReturningClauseTokenCount();
            }
            return this;
        }

        final ParserState nextForCloseToken(ReturningClauseDetector detector) {
            ParserState restoredState = detector.popParserState();
            if (restoredState == IN_RETURNING) {
                detector.incrementReturningClauseTokenCount();
            }
            return restoredState;
        }
    }
}

