/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version10;

import java.io.IOException;
import java.sql.SQLException;
import org.firebirdsql.gds.ServiceParameterBuffer;
import org.firebirdsql.gds.ServiceRequestBuffer;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.dbcrypt.DbCryptCallback;
import org.firebirdsql.gds.ng.wire.AbstractFbWireService;
import org.firebirdsql.gds.ng.wire.FbWireAttachment;
import org.firebirdsql.gds.ng.wire.FbWireService;
import org.firebirdsql.gds.ng.wire.GenericResponse;
import org.firebirdsql.gds.ng.wire.ProtocolDescriptor;
import org.firebirdsql.gds.ng.wire.WireServiceConnection;

public class V10Service
extends AbstractFbWireService
implements FbWireService {
    public V10Service(WireServiceConnection connection, ProtocolDescriptor descriptor) {
        super(connection, descriptor);
    }

    @Override
    public void attach() throws SQLException {
        try {
            this.checkConnected();
            this.requireNotAttached();
            try (LockCloseable ignored = this.withLock();){
                try {
                    this.sendAttach();
                    this.receiveAttachResponse();
                }
                catch (SQLException e) {
                    this.safelyDetach();
                    throw e;
                }
                this.setAttached();
                this.afterAttachActions();
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    private void sendAttach() throws SQLException {
        try {
            this.sendAttachToBuffer(this.protocolDescriptor.createAttachServiceParameterBuffer((WireServiceConnection)this.connection));
            this.getXdrOut().flush();
        }
        catch (IOException e) {
            throw FbExceptionBuilder.ioWriteError(e);
        }
    }

    private void receiveAttachResponse() throws SQLException {
        try {
            this.authReceiveResponse(null);
        }
        catch (IOException e) {
            throw FbExceptionBuilder.ioReadError(e);
        }
    }

    protected void processAttachResponse(GenericResponse genericResponse) {
    }

    protected void afterAttachActions() throws SQLException {
        this.getServiceInfo((ServiceParameterBuffer)null, this.getDescribeServiceRequestBuffer(), 1024, this.getServiceInformationProcessor());
        ((WireServiceConnection)this.connection).resetSocketTimeout();
    }

    protected void sendAttachToBuffer(ServiceParameterBuffer spb) throws SQLException, IOException {
        XdrOutputStream xdrOut = this.getXdrOut();
        xdrOut.writeInt(82);
        xdrOut.writeInt(0);
        xdrOut.writeString(((WireServiceConnection)this.connection).getAttachObjectName(), this.getEncoding());
        xdrOut.writeTyped(spb);
    }

    @Override
    protected void internalDetach() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            try {
                this.sendDetachDisconnect();
                if (this.isAttached()) {
                    this.receiveDetachResponse();
                }
                try {
                    this.closeConnection();
                }
                catch (IOException e) {
                    throw FbExceptionBuilder.ioWriteError(e);
                }
            }
            catch (SQLException ex) {
                try {
                    this.closeConnection();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw ex;
            }
            finally {
                this.setDetached();
            }
        }
    }

    private void sendDetachDisconnect() throws SQLException {
        try {
            XdrOutputStream xdrOut = this.getXdrOut();
            if (this.isAttached()) {
                xdrOut.writeInt(83);
                xdrOut.writeInt(0);
            }
            xdrOut.writeInt(6);
            xdrOut.flush();
        }
        catch (IOException e) {
            throw FbExceptionBuilder.ioWriteError(e);
        }
    }

    private void receiveDetachResponse() throws SQLException {
        try {
            this.wireOperations.readResponse(null);
        }
        catch (IOException e) {
            throw FbExceptionBuilder.ioReadError(e);
        }
    }

    @Override
    public byte[] getServiceInfo(ServiceParameterBuffer serviceParameterBuffer, ServiceRequestBuffer serviceRequestBuffer, int maxBufferLength) throws SQLException {
        LockCloseable ignored = this.withLock();
        try {
            this.checkAttached();
            this.sendServiceInfo(serviceParameterBuffer, serviceRequestBuffer, maxBufferLength);
            byte[] byArray = this.receiveServiceInfoResponse();
            if (ignored != null) {
                ignored.close();
            }
            return byArray;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                this.exceptionListenerDispatcher.errorOccurred(e);
                throw e;
            }
        }
    }

    private void sendServiceInfo(ServiceParameterBuffer serviceParameterBuffer, ServiceRequestBuffer serviceRequestBuffer, int maxBufferLength) throws SQLException {
        try {
            XdrOutputStream xdrOut = this.getXdrOut();
            xdrOut.writeInt(84);
            xdrOut.writeInt(0);
            xdrOut.writeInt(0);
            xdrOut.writeBuffer(serviceParameterBuffer != null ? serviceParameterBuffer.toBytes() : null);
            xdrOut.writeBuffer(serviceRequestBuffer.toBytes());
            xdrOut.writeInt(maxBufferLength);
            xdrOut.flush();
        }
        catch (IOException e) {
            throw FbExceptionBuilder.ioWriteError(e);
        }
    }

    private byte[] receiveServiceInfoResponse() throws SQLException {
        try {
            return this.readGenericResponse(null).data();
        }
        catch (IOException e) {
            throw FbExceptionBuilder.ioReadError(e);
        }
    }

    @Override
    public void startServiceAction(ServiceRequestBuffer serviceRequestBuffer) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkAttached();
            this.sendServiceStart(serviceRequestBuffer);
            this.receiveServiceStartResponse();
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    private void sendServiceStart(ServiceRequestBuffer serviceRequestBuffer) throws SQLException {
        try {
            XdrOutputStream xdrOut = this.getXdrOut();
            xdrOut.writeInt(85);
            xdrOut.writeInt(0);
            xdrOut.writeInt(0);
            xdrOut.writeBuffer(serviceRequestBuffer.toBytes());
            xdrOut.flush();
        }
        catch (IOException e) {
            throw FbExceptionBuilder.ioWriteError(e);
        }
    }

    private void receiveServiceStartResponse() throws SQLException {
        try {
            this.readGenericResponse(null);
        }
        catch (IOException e) {
            throw FbExceptionBuilder.ioReadError(e);
        }
    }

    @Override
    public final void authReceiveResponse(FbWireAttachment.AcceptPacket acceptPacket) throws IOException, SQLException {
        DbCryptCallback dbCryptCallback = ((WireServiceConnection)this.connection).createDbCryptCallback();
        this.wireOperations.authReceiveResponse(acceptPacket, dbCryptCallback, this::processAttachResponse);
    }
}

